/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net.transport.impl;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.PacketContext;
import com.zeitheron.hammercore.net.transport.ITransportAcceptor;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;

public class PacketWrapperAcceptor
implements ITransportAcceptor {
    NBTTagCompound data;
    IPacket decoded;

    @Override
    public void read(InputStream readable, int length) {
        try {
            this.data = CompressedStreamTools.func_152456_a((DataInput)new DataInputStream(readable), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
            this.decoded = HCNet.readPacket(this.data);
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    @Override
    public void onTransmissionComplete(Side side, PacketContext ctx) {
        if (this.decoded == null) {
            HammerCore.LOG.error("Received bad packet on packet transport (WHAT IS THIS?!): " + this.data);
        } else {
            switch (side) {
                case CLIENT: {
                    this.decoded.executeOnClient2(ctx);
                    break;
                }
                case SERVER: {
                    this.decoded.executeOnServer2(ctx);
                    break;
                }
                default: {
                    HammerCore.LOG.error("WTF is this side " + side + " ?!");
                }
            }
        }
    }

    @Override
    public boolean executeOnMainThread() {
        return ITransportAcceptor.super.executeOnMainThread() || this.decoded != null && this.decoded.executeOnMainThread();
    }
}

