/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client;

import com.zeitheron.hammercore.api.lighting.ColoredLightManager;
import com.zeitheron.hammercore.client.render.shader.GlShaderStack;
import com.zeitheron.hammercore.event.client.ClientLoadedInEvent;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.internal.PacketPing;
import com.zeitheron.hammercore.net.internal.PacketPlayerReady;
import com.zeitheron.hammercore.proxy.RenderProxy_Client;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.Locale;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HammerCoreClient {
    public static long ping;
    int pingTimer = 40;
    boolean renderedWorld = false;

    public static void runPingTest() {
        HCNet.INSTANCE.sendToServer(new PacketPing(System.currentTimeMillis()));
    }

    public static MetadataSerializer getMetadataSerializer() {
        return Minecraft.func_71410_x().field_110452_an;
    }

    public static void emptyBlockState(Block block) {
        RenderProxy_Client.EMP.empty(block);
    }

    @SubscribeEvent
    public void renderWorldLast(RenderWorldLastEvent e) {
        if (!this.renderedWorld) {
            HCNet.INSTANCE.sendToServer(new PacketPlayerReady());
            MinecraftForge.EVENT_BUS.post((Event)new ClientLoadedInEvent());
            this.renderedWorld = true;
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent cte) {
        boolean inWorld;
        if (cte.phase != TickEvent.Phase.START) {
            return;
        }
        GlShaderStack.clearStack();
        boolean bl = inWorld = Minecraft.func_71410_x().field_71441_e != null;
        if (this.renderedWorld && !inWorld) {
            this.renderedWorld = false;
            ColoredLightManager.resetTileCache();
        }
        if (this.renderedWorld && this.pingTimer-- <= 0) {
            this.pingTimer = 40;
            HammerCoreClient.runPingTest();
        }
    }

    public static void injectResourcePack(IResourcePack pack) {
        try {
            Field resourcePackList = FMLClientHandler.class.getDeclaredField("resourcePackList");
            resourcePackList.setAccessible(true);
            List rps = (List)resourcePackList.get(FMLClientHandler.instance());
            rps.add(3, pack);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static void injectResourcePackLast(IResourcePack pack) {
        try {
            Field resourcePackList = FMLClientHandler.class.getDeclaredField("resourcePackList");
            resourcePackList.setAccessible(true);
            List rps = (List)resourcePackList.get(FMLClientHandler.instance());
            rps.add(pack);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static void injectLanguages(Map<String, Map<String, String>> localizations) {
        Field i18nLocalef = I18n.class.getDeclaredFields()[0];
        i18nLocalef.setAccessible(true);
        try {
            StringBuilder sb;
            Locale locale = (Locale)Locale.class.cast(i18nLocalef.get(null));
            Field propertiesf = Locale.class.getDeclaredFields()[2];
            propertiesf.setAccessible(true);
            Map properties = (Map)Map.class.cast(propertiesf.get(locale));
            String code = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
            if (localizations.containsKey("en_us")) {
                properties.putAll(localizations.get("en_us"));
                sb = new StringBuilder("# Builtin & Generated by HammerCore lang file.\n");
                localizations.get("en_us").entrySet().stream().map(ln -> "\n" + (String)ln.getKey() + "=" + (String)ln.getValue()).forEach(sb::append);
                LanguageMap.inject((InputStream)new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)));
            }
            if (localizations.containsKey(code)) {
                properties.putAll(localizations.get(code));
                sb = new StringBuilder("# Builtin & Generated by HammerCore lang file.\n");
                localizations.get(code).entrySet().stream().map(ln -> "\n" + (String)ln.getKey() + "=" + (String)ln.getValue()).forEach(sb::append);
                LanguageMap.inject((InputStream)new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)));
            }
        }
        catch (ReflectiveOperationException err) {
            err.printStackTrace();
        }
    }
}

