/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.asm;

import com.zeitheron.hammercore.asm.HCASM;
import com.zeitheron.hammercore.asm.ObjectWebUtils;
import com.zeitheron.hammercore.lib.zlib.utils.TaskedThread;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

class TransformerSystem {
    private String indentstr = "";
    private int indents = 0;
    private final List<iASMHook> hooks = new ArrayList<iASMHook>();
    private final TaskedThread SAVE_THREAD = new TaskedThread();
    private final File CLASS_SAVE_DIR = new File("HammerCore", "asm_classes");
    String currentClass;
    String transformedCurrentClass;

    TransformerSystem() {
    }

    private void saveClass(byte[] original, byte[] modified, String clazz) {
        byte[] o = (byte[])original.clone();
        byte[] m = (byte[])modified.clone();
        this.SAVE_THREAD.addTask(() -> {
            if (!this.CLASS_SAVE_DIR.isDirectory()) {
                this.CLASS_SAVE_DIR.mkdirs();
            }
            try {
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new File(this.CLASS_SAVE_DIR, clazz.replaceAll("/", "_").replaceAll("[.]", "_") + ".zip")));
                zos.putNextEntry(new ZipEntry("origin.class"));
                zos.write(original);
                zos.closeEntry();
                if (!Arrays.equals(modified, original)) {
                    zos.putNextEntry(new ZipEntry("modified.class"));
                    zos.write(modified);
                    zos.closeEntry();
                }
                zos.putNextEntry(new ZipEntry("methods.txt"));
                ClassNode cn = ObjectWebUtils.loadClass(m);
                for (MethodNode mn : cn.methods) {
                    zos.write((mn.name + " " + mn.desc + "\n").getBytes());
                }
                zos.closeEntry();
                zos.close();
            }
            catch (IOException e) {
                this.info("Failed to save ASM class for " + clazz);
                e.printStackTrace();
            }
        });
    }

    public void push() {
        if (this.indents < 15) {
            ++this.indents;
        }
        this.indentstr = "";
        for (int i = 0; i < this.indents; ++i) {
            this.indentstr = this.indentstr + "  ";
        }
    }

    public void pop() {
        if (this.indents > 0) {
            --this.indents;
        }
        this.indentstr = "";
        for (int i = 0; i < this.indents; ++i) {
            this.indentstr = this.indentstr + "  ";
        }
    }

    public void info(String text) {
        if (this.indents == 0) {
            HCASM.ASM_LOG.info(text);
        } else {
            HCASM.ASM_LOG.info(this.indentstr + "-" + text);
        }
    }

    public void addHook(iASMHook hook) {
        this.hooks.add(hook);
    }

    public String getCurrentClass() {
        return this.currentClass;
    }

    public String getTransformedCurrentClass() {
        return this.transformedCurrentClass;
    }

    public byte[] transform(String name, String transformedName, byte[] data) {
        this.currentClass = name;
        this.transformedCurrentClass = transformedName;
        byte[] origin = data;
        boolean l = false;
        for (iASMHook h : this.hooks) {
            if (!h.accepts(transformedName) && !h.accepts(name)) continue;
            if (!l) {
                l = true;
                this.info("Transforming " + transformedName + " (" + name + ")...");
            }
            this.push();
            if (h.opName() != null) {
                this.info(h.opName());
            }
            boolean obf = !name.equals(transformedName);
            ClassNode node = ObjectWebUtils.loadClass(data);
            this.currentClass = name;
            this.transformedCurrentClass = transformedName;
            this.push();
            h.transform(node, obf);
            this.pop();
            data = ObjectWebUtils.writeClassToByteArray(node);
            this.pop();
        }
        this.currentClass = null;
        this.transformedCurrentClass = null;
        return data;
    }

    public static interface iASMHook {
        public boolean accepts(String var1);

        public String opName();

        public void transform(ClassNode var1, boolean var2);
    }
}

