/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.util;

import com.google.common.collect.Sets;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.elements.LinkContext;
import gigaherz.guidebook.network.GiveItemPacket;
import gigaherz.guidebook.network.NetworkHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class LinkHelper {
    private static final Set<String> PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});

    public static void giveItem(String giveItemString) {
        Item item;
        String[] parts = giveItemString.split(":");
        int coinsNeeded = Integer.parseInt(parts[0]);
        ResourceLocation inputItem = new ResourceLocation(parts[1], parts[2]);
        int meta = 0;
        int quantity = 1;
        if (parts.length == 4) {
            try {
                meta = Integer.parseInt(parts[3]);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid meta value for " + giveItemString);
                return;
            }
        }
        if (parts.length == 5) {
            try {
                quantity = Integer.parseInt(parts[4]);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid quantity for " + giveItemString);
                return;
            }
        }
        if ((item = (Item)Item.field_150901_e.func_82594_a((Object)inputItem)) == null) {
            System.out.println("Item not found: " + inputItem);
            return;
        }
        ItemStack itemStack = new ItemStack(item, quantity, meta);
        if (Minecraft.func_71410_x().field_71441_e.field_72995_K) {
            NetworkHandler.INSTANCE.sendToServer((IMessage)new GiveItemPacket(itemStack, coinsNeeded));
        }
    }

    public static void click(IBookGraphics nav, LinkContext context) {
        if (context.textTarget != null && context.textAction != null) {
            switch (context.textAction) {
                case "openUrl": {
                    LinkHelper.clickWeb(nav, context.textTarget);
                    break;
                }
                case "copyText": {
                    LinkHelper.clickCopyToClipboard(nav, context.textTarget);
                    break;
                }
                case "copyToChat": {
                    LinkHelper.clickCopyToChat(nav, context.textTarget);
                    break;
                }
                case "giveItem": {
                    LinkHelper.giveItem(context.textTarget);
                }
            }
        }
        if (context.target != null) {
            nav.navigateTo(context.target);
        }
    }

    public static void clickCopyToClipboard(IBookGraphics nav, String textTarget) {
        final GuiScreen parent = (GuiScreen)nav.owner();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((GuiScreen)new GuiYesNo((result, id) -> {
            if (result) {
                GuiScreen.func_146275_d((String)textTarget);
                mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("text.copyToClipboard.success", new Object[0]));
            }
            mc.func_147108_a(parent);
        }, I18n.func_135052_a((String)"text.copyToClipboard.line1", (Object[])new Object[0]), I18n.func_135052_a((String)"text.copyToClipboard.line2", (Object[])new Object[0]), 0){

            public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
                parent.func_73863_a(-1, -1, partialTicks);
                super.func_73863_a(mouseX, mouseY, partialTicks);
            }
        });
    }

    public static void clickCopyToChat(IBookGraphics nav, String textTarget) {
        final GuiScreen parent = (GuiScreen)nav.owner();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((GuiScreen)new GuiChat(textTarget){

            public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
                parent.func_73863_a(-1, -1, partialTicks);
                String text = "Temporary chat window open, press ESCAPE to cancel.";
                int textWidth = Math.max(this.field_146289_q.func_78256_a(text) + 40, this.field_146294_l / 2);
                2.func_73734_a((int)((this.field_146294_l - textWidth) / 2), (int)(this.field_146295_m / 4), (int)((this.field_146294_l + textWidth) / 2), (int)(this.field_146295_m * 3 / 4), (int)0x7F000000);
                this.func_73732_a(this.field_146289_q, text, this.field_146294_l / 2, (this.field_146295_m - this.field_146289_q.field_78288_b) / 2, -1);
                super.func_73863_a(mouseX, mouseY, partialTicks);
            }

            protected void func_73869_a(char typedChar, int keyCode) throws IOException {
                if (keyCode == 1) {
                    this.field_146297_k.func_147108_a(parent);
                } else if (keyCode == 156 || keyCode == 28) {
                    String s = this.field_146415_a.func_146179_b().trim();
                    if (!s.isEmpty()) {
                        this.func_175275_f(s);
                    }
                    this.field_146297_k.func_147108_a(parent);
                } else {
                    super.func_73869_a(typedChar, keyCode);
                }
            }
        });
    }

    public static void clickWeb(IBookGraphics nav, String textTarget) {
        final GuiScreen parent = (GuiScreen)nav.owner();
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71474_y.field_74359_p) {
            return;
        }
        try {
            URI uri = new URI(textTarget);
            String s = uri.getScheme();
            if (s == null) {
                throw new URISyntaxException(textTarget, "Missing protocol");
            }
            if (!PROTOCOLS.contains(s.toLowerCase(Locale.ROOT))) {
                throw new URISyntaxException(textTarget, "Unsupported protocol: " + s.toLowerCase(Locale.ROOT));
            }
            if (mc.field_71474_y.field_74358_q) {
                ObfuscationReflectionHelper.setPrivateValue(GuiScreen.class, (Object)parent, (Object)uri, (String)"field_175286_t");
                mc.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)parent, textTarget, 31102009, false){

                    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
                        parent.func_73863_a(-1, -1, partialTicks);
                        super.func_73863_a(mouseX, mouseY, partialTicks);
                    }
                });
            } else {
                LinkHelper.openWebLink(uri);
            }
        }
        catch (URISyntaxException urisyntaxexception) {
            GuidebookMod.logger.error("Can't open url {}", (Object)textTarget, (Object)urisyntaxexception);
        }
    }

    private static void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable1) {
            GuidebookMod.logger.error("Can't open url {}", (Object)url, (Object)throwable1);
        }
    }

    public static interface ILinkable {
        public void setLinkContext(LinkContext var1);
    }
}

