/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.IConditionSource;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.drawing.VisualText;
import gigaherz.guidebook.guidebook.elements.ElementInline;
import gigaherz.guidebook.guidebook.elements.ElementParagraph;
import gigaherz.guidebook.guidebook.elements.TextStyle;
import gigaherz.guidebook.guidebook.util.Rect;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.text.TextFormatting;
import org.w3c.dom.NamedNodeMap;

public class ElementText
extends ElementInline {
    public final String text;
    public int color;
    public boolean bold;
    public boolean italics;
    public boolean underline;
    public float scale = 1.0f;
    private ElementParagraph temporaryParagraph = null;

    public ElementText(String text, boolean isFirstElement, boolean isLastElement, TextStyle style) {
        super(isFirstElement, isLastElement);
        this.text = ElementText.compactString(text, isFirstElement, isLastElement);
        this.color = style.color;
        this.bold = style.bold;
        this.italics = style.italics;
        this.underline = style.underline;
        this.scale = style.scale;
    }

    public static String compactString(String text, boolean trimLeft, boolean trimRight) {
        if (text == null) {
            return null;
        }
        String temp = text;
        if (trimRight) {
            temp = temp.replaceAll("[ \t]+$", "");
        }
        return temp;
    }

    private String getStringWithFormat() {
        String textWithFormat = this.getActualString();
        textWithFormat = this.formatter(this.text, Pattern.compile("\\*"), TextFormatting.BOLD);
        return textWithFormat;
    }

    protected String getActualString() {
        return this.text;
    }

    private String formatter(String text, Pattern pattern, TextFormatting textFormatting) {
        Matcher matcher;
        boolean flipper = true;
        while ((matcher = pattern.matcher(text)).find()) {
            text = flipper ? matcher.replaceFirst(textFormatting + "") : matcher.replaceFirst(TextFormatting.RESET + "");
            flipper = !flipper;
        }
        return text;
    }

    @Override
    public List<VisualElement> measure(IBookGraphics nav, int width, int firstLineWidth) {
        List<VisualElement> elements = nav.measure(this.getStringWithFormat(), width, firstLineWidth, this.scale, this.position, this.baseline, this.verticalAlignment);
        for (VisualElement text : elements) {
            if (!(text instanceof VisualText)) continue;
            ((VisualText)text).color = this.color;
        }
        return elements;
    }

    @Override
    public int reflow(List<VisualElement> paragraph, IBookGraphics nav, Rect bounds, Rect page) {
        if (this.temporaryParagraph == null) {
            this.temporaryParagraph = new ElementParagraph();
            this.temporaryParagraph.inlines.add(this);
        }
        return this.temporaryParagraph.reflow(paragraph, nav, bounds, page);
    }

    @Override
    public void parse(IConditionSource book, NamedNodeMap attributes) {
        super.parse(book, attributes);
        this.scale = ElementText.getAttribute(attributes, "scale", this.scale);
    }

    @Override
    public String toString(boolean complete) {
        return this.text;
    }

    @Override
    public ElementInline copy() {
        ElementText span = super.copy(new ElementText(this.text, false, false, new TextStyle(this.color, this.bold, this.italics, this.underline, this.scale)));
        span.color = this.color;
        span.bold = this.bold;
        span.italics = this.italics;
        span.underline = this.underline;
        span.scale = this.scale;
        return span;
    }
}

