/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.api;

import amerifrance.guideapi.api.IInfoRenderer;
import amerifrance.guideapi.api.impl.Book;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuideAPI {
    private static final Map<ResourceLocation, Book> BOOKS = Maps.newHashMap();
    private static final Map<Book, ItemStack> BOOK_TO_STACK = Maps.newHashMap();
    private static final Map<Book, Multimap<Class<? extends Block>, IInfoRenderer>> INFO_RENDERERS = Maps.newHashMap();
    private static List<Book> indexedBooks = Lists.newArrayList();

    public static ItemStack getStackFromBook(Book book) {
        return BOOK_TO_STACK.get(book) == null ? ItemStack.field_190927_a : BOOK_TO_STACK.get(book);
    }

    public static void registerInfoRenderer(Book book, IInfoRenderer infoRenderer, Class<? extends Block> ... blockClasses) {
        if (!INFO_RENDERERS.containsKey(book)) {
            INFO_RENDERERS.put(book, (Multimap<Class<? extends Block>, IInfoRenderer>)ArrayListMultimap.create());
        }
        for (Class<? extends Block> blockClass : blockClasses) {
            INFO_RENDERERS.get(book).put(blockClass, (Object)infoRenderer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void setModel(Book book, ResourceLocation modelLoc, String variantName) {
        ModelResourceLocation mrl = new ModelResourceLocation(modelLoc, variantName);
        ModelLoader.setCustomModelResourceLocation((Item)GuideAPI.getStackFromBook(book).func_77973_b(), (int)0, (ModelResourceLocation)mrl);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setModel(Book book) {
        GuideAPI.setModel(book, new ResourceLocation("guideapi", "ItemGuideBook"), "inventory");
    }

    public static void initialize() {
    }

    public static Map<ResourceLocation, Book> getBooks() {
        return ImmutableMap.copyOf(BOOKS);
    }

    public static Map<Book, ItemStack> getBookToStack() {
        return ImmutableMap.copyOf(BOOK_TO_STACK);
    }

    public static Map<Book, Multimap<Class<? extends Block>, IInfoRenderer>> getInfoRenderers() {
        return ImmutableMap.copyOf(INFO_RENDERERS);
    }

    public static List<Book> getIndexedBooks() {
        return ImmutableList.copyOf(indexedBooks);
    }
}

