/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.TransformerHooks;
import micdoodle8.mods.galacticraft.core.entities.IControllableEntity;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.network.PacketEntityUpdate;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.TileEntityBuggyFueler;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBuggy
extends Entity
implements IInventory,
IPacketReceiver,
IDockable,
IControllableEntity,
PacketEntityUpdate.IEntityFullSync {
    public static final int tankCapacity = 1000;
    private static final DataParameter<Integer> CURRENT_DAMAGE = EntityDataManager.func_187226_a(EntityBuggy.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityBuggy.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ROCK_DIRECTION = EntityDataManager.func_187226_a(EntityBuggy.class, (DataSerializer)DataSerializers.field_187192_b);
    public FluidTank buggyFuelTank = new FluidTank(1000);
    public int buggyType;
    public int currentDamage;
    public int timeSinceHit;
    public int rockDirection;
    public double speed;
    public float wheelRotationZ;
    public float wheelRotationX;
    public String texture;
    public double boatX;
    public double boatY;
    public double boatZ;
    public double boatYaw;
    public double boatPitch;
    public int boatPosRotationIncrements;
    protected long ticks = 0L;
    float maxSpeed = 0.5f;
    float accel = 0.2f;
    float turnFactor = 3.0f;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)60, (Object)ItemStack.field_190927_a);
    private IFuelDock landingPad;
    private int timeClimbing;
    private boolean shouldClimb;

    public EntityBuggy(World var1) {
        super(var1);
        this.func_70105_a(0.98f, 1.4f);
        this.speed = 0.0;
        this.field_70156_m = true;
        this.field_70180_af.func_187214_a(CURRENT_DAMAGE, (Object)0);
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(ROCK_DIRECTION, (Object)1);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
        if (var1 != null && var1.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketDynamic(this));
        }
    }

    public EntityBuggy(World var1, double var2, double var4, double var6, int type) {
        this(var1);
        this.func_70107_b(var2, var4, var6);
        this.setBuggyType(type);
        this.stacks = NonNullList.func_191197_a((int)(this.buggyType * 18), (Object)ItemStack.field_190927_a);
    }

    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.buggyFuelTank.getFluid() == null ? 0.0 : (double)this.buggyFuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / 1000.0);
    }

    public ModelBase getModel() {
        return null;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(GCItems.buggy, 1, this.buggyType);
    }

    public int getType() {
        return this.buggyType;
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O - 3.0;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void setBuggyType(int par1) {
        this.buggyType = par1;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            double offsetX = Math.cos((double)this.field_70177_z / 57.29577951308232 + 114.8) * -0.5;
            double offsetZ = Math.sin((double)this.field_70177_z / 57.29577951308232 + 114.8) * -0.5;
            passenger.func_70107_b(this.field_70165_t + offsetX, this.field_70163_u + (double)0.4f + passenger.func_70033_W(), this.field_70161_v + offsetZ);
        }
    }

    @Override
    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, double motX, double motY, double motZ, boolean onGround) {
        if (this.field_70170_p.field_72995_K) {
            this.boatX = x;
            this.boatY = y;
            this.boatZ = z;
            this.boatYaw = yaw;
            this.boatPitch = pitch;
            this.field_70159_w = motX;
            this.field_70181_x = motY;
            this.field_70179_y = motZ;
            this.boatPosRotationIncrements = 5;
        } else {
            this.func_70107_b(x, y, z);
            this.func_70101_b(yaw, pitch);
            this.field_70159_w = motX;
            this.field_70181_x = motY;
            this.field_70179_y = motZ;
        }
    }

    public void func_70057_ab() {
        this.field_70180_af.func_187227_b(ROCK_DIRECTION, (Object)(-((Integer)this.field_70180_af.func_187225_a(ROCK_DIRECTION)).intValue()));
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)10);
        this.field_70180_af.func_187227_b(CURRENT_DAMAGE, (Object)((Integer)this.field_70180_af.func_187225_a(CURRENT_DAMAGE) * 5));
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        boolean flag;
        if (this.field_70128_L || var1.equals(DamageSource.field_76367_g)) {
            return true;
        }
        Entity e = var1.func_76346_g();
        boolean bl = flag = e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d;
        if (this.func_180431_b(var1) || e instanceof EntityLivingBase && !(e instanceof EntityPlayer)) {
            return false;
        }
        this.field_70180_af.func_187227_b(ROCK_DIRECTION, (Object)(-((Integer)this.field_70180_af.func_187225_a(ROCK_DIRECTION)).intValue()));
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)10);
        this.field_70180_af.func_187227_b(CURRENT_DAMAGE, (Object)((int)((float)((Integer)this.field_70180_af.func_187225_a(CURRENT_DAMAGE)).intValue() + var2 * 10.0f)));
        this.func_70018_K();
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
            this.field_70180_af.func_187227_b(CURRENT_DAMAGE, (Object)100);
        }
        if (flag || (Integer)this.field_70180_af.func_187225_a(CURRENT_DAMAGE) > 2) {
            if (!this.func_184188_bt().isEmpty()) {
                this.func_184226_ay();
            }
            if (flag) {
                this.func_70106_y();
            } else {
                this.func_70106_y();
                if (!this.field_70170_p.field_72995_K) {
                    this.dropBuggyAsItem();
                }
            }
            this.func_70106_y();
        }
        return true;
    }

    public void dropBuggyAsItem() {
        List<ItemStack> dropped = this.getItemsDropped();
        if (dropped == null) {
            return;
        }
        for (ItemStack item : dropped) {
            EntityItem entityItem = this.func_70099_a(item, 0.0f);
            if (!item.func_77942_o()) continue;
            entityItem.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
        }
    }

    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack buggy = new ItemStack(GCItems.buggy, 1, this.buggyType);
        buggy.func_77982_d(new NBTTagCompound());
        buggy.func_77978_p().func_74768_a("BuggyFuel", this.buggyFuelTank.getFluidAmount());
        items.add(buggy);
        for (ItemStack item : this.stacks) {
            if (item.func_190926_b()) continue;
            items.add(item);
        }
        return items;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean b) {
        if (!this.func_184188_bt().isEmpty() && !this.func_184188_bt().contains(FMLClientHandler.instance().getClient().field_71439_g)) {
            this.boatPosRotationIncrements = posRotationIncrements + 5;
            this.boatX = x;
            this.boatY = y;
            this.boatZ = z;
            this.boatYaw = yaw;
            this.boatPitch = pitch;
        }
    }

    public void func_70071_h_() {
        double d;
        ++this.ticks;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.wheelRotationX = (float)((double)this.wheelRotationX + Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 150.0 * (double)(this.speed < 0.0 ? 1 : -1));
            this.wheelRotationX %= 360.0f;
            this.wheelRotationZ = Math.max(-30.0f, Math.min(30.0f, this.wheelRotationZ * 0.9f));
        }
        if (this.field_70170_p.field_72995_K && !FMLClientHandler.instance().getClient().field_71439_g.equals((Object)this.field_70170_p.func_72890_a((Entity)this, -1.0))) {
            if (this.boatPosRotationIncrements > 0) {
                double x = this.field_70165_t + (this.boatX - this.field_70165_t) / (double)this.boatPosRotationIncrements;
                double y = this.field_70163_u + (this.boatY - this.field_70163_u) / (double)this.boatPosRotationIncrements;
                double z = this.field_70161_v + (this.boatZ - this.field_70161_v) / (double)this.boatPosRotationIncrements;
                double var12 = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + var12 / (double)this.boatPosRotationIncrements);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.boatPitch - (double)this.field_70125_A) / (double)this.boatPosRotationIncrements);
                --this.boatPosRotationIncrements;
                this.func_70107_b(x, y, z);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                double x = this.field_70165_t + this.field_70159_w;
                double y = this.field_70163_u + this.field_70181_x;
                double z = this.field_70161_v + this.field_70179_y;
                if (!this.func_184188_bt().isEmpty()) {
                    this.func_70107_b(x, y, z);
                }
                if (this.field_70122_E) {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                }
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
            return;
        }
        if ((Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT) > 0) {
            this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)((Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT) - 1));
        }
        if ((Integer)this.field_70180_af.func_187225_a(CURRENT_DAMAGE) > 0) {
            this.field_70180_af.func_187227_b(CURRENT_DAMAGE, (Object)((Integer)this.field_70180_af.func_187225_a(CURRENT_DAMAGE) - 1));
        }
        if (!this.field_70122_E) {
            this.field_70181_x -= TransformerHooks.getGravityForEntity(this) * 0.5;
        }
        if (this.field_70171_ac && this.speed > 0.2) {
            this.field_70170_p.func_184148_a(null, (double)((float)this.field_70165_t), (double)((float)this.field_70163_u), (double)((float)this.field_70161_v), SoundEvents.field_187658_bx, SoundCategory.NEUTRAL, 0.5f, 2.6f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
        }
        this.speed *= 0.98;
        if (this.speed > (double)this.maxSpeed) {
            this.speed = this.maxSpeed;
        }
        if (this.field_70123_F && this.shouldClimb) {
            this.speed *= 0.9;
            this.field_70181_x = 0.15 * (-Math.pow(this.timeClimbing - 1, 2.0) / 250.0) + (double)0.15f;
            this.field_70181_x = Math.max(-0.15, this.field_70181_x);
            this.shouldClimb = false;
        }
        this.timeClimbing = !(this.field_70159_w != 0.0 && this.field_70179_y != 0.0 || this.field_70122_E) ? ++this.timeClimbing : 0;
        if (this.field_70170_p.field_72995_K && this.buggyFuelTank.getFluid() != null && this.buggyFuelTank.getFluid().amount > 0) {
            this.field_70159_w = -(this.speed * Math.cos((double)(this.field_70177_z - 90.0f) / 57.29577951308232));
            this.field_70179_y = -(this.speed * Math.sin((double)(this.field_70177_z - 90.0f) / 57.29577951308232));
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        if (!this.field_70170_p.field_72995_K && Math.abs(this.field_70159_w * this.field_70179_y) > 1.0E-6 && (d = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) != 0.0 && this.ticks % (long)(MathHelper.func_76128_c((double)(2.0 / d)) + 1) == 0L) {
            this.removeFuel(1);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70170_p.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketEntityUpdate(this));
        } else if (this.ticks % 5L == 0L) {
            GalacticraftCore.packetPipeline.sendToAllAround(new PacketEntityUpdate(this), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0));
            GalacticraftCore.packetPipeline.sendToAllAround(new PacketDynamic(this), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0));
        }
    }

    @Override
    public void getNetworkedData(ArrayList<Object> sendData) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        sendData.add(this.buggyType);
        sendData.add(this.buggyFuelTank);
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        this.buggyType = buffer.readInt();
        try {
            this.buggyFuelTank = NetworkUtil.readFluidTank(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.buggyType = nbt.func_74762_e("buggyType");
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks);
        if (nbt.func_74764_b("fuelTank")) {
            this.buggyFuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        nbt.func_74768_a("buggyType", this.buggyType);
        NBTTagList var2 = new NBTTagList();
        if (this.buggyFuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.buggyFuelTank.writeToNBT(new NBTTagCompound()));
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks);
    }

    public int func_70302_i_() {
        return this.buggyType * 18;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.stacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return "Buggy";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return !this.field_70128_L && var1.func_70068_e((Entity)this) <= 64.0;
    }

    public void func_70296_d() {
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            if (this.func_184188_bt().isEmpty()) {
                player.func_145747_a((ITextComponent)new TextComponentString(GameSettings.func_74298_c((int)KeyHandlerClient.leftKey.func_151463_i()) + " / " + GameSettings.func_74298_c((int)KeyHandlerClient.rightKey.func_151463_i()) + "  - " + GCCoreUtil.translate("gui.buggy.turn.name")));
                player.func_145747_a((ITextComponent)new TextComponentString(GameSettings.func_74298_c((int)KeyHandlerClient.accelerateKey.func_151463_i()) + "       - " + GCCoreUtil.translate("gui.buggy.accel.name")));
                player.func_145747_a((ITextComponent)new TextComponentString(GameSettings.func_74298_c((int)KeyHandlerClient.decelerateKey.func_151463_i()) + "       - " + GCCoreUtil.translate("gui.buggy.decel.name")));
            }
            return true;
        }
        if (this.func_184188_bt().contains(player)) {
            this.func_184225_p((Entity)player);
            return true;
        }
        player.func_184220_m((Entity)this);
        return true;
    }

    @Override
    public boolean pressKey(int key) {
        if (this.field_70170_p.field_72995_K && (key == 6 || key == 8 || key == 9)) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_CONTROL_ENTITY, GCCoreUtil.getDimensionID(this.field_70170_p), new Object[]{key}));
            return true;
        }
        switch (key) {
            case 0: {
                this.speed += (double)this.accel / 20.0;
                this.shouldClimb = true;
                return true;
            }
            case 1: {
                this.speed -= (double)this.accel / 20.0;
                this.shouldClimb = true;
                return true;
            }
            case 2: {
                this.field_70177_z -= 0.5f * this.turnFactor;
                this.wheelRotationZ = Math.max(-30.0f, Math.min(30.0f, this.wheelRotationZ + 0.5f));
                return true;
            }
            case 3: {
                this.field_70177_z += 0.5f * this.turnFactor;
                this.wheelRotationZ = Math.max(-30.0f, Math.min(30.0f, this.wheelRotationZ - 0.5f));
                return true;
            }
        }
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public int addFuel(FluidStack liquid, boolean doDrain) {
        if (this.landingPad != null) {
            return FluidUtil.fillWithGCFuel(this.buggyFuelTank, liquid, doDrain);
        }
        return 0;
    }

    @Override
    public FluidStack removeFuel(int amount) {
        return this.buggyFuelTank.drain(amount, true);
    }

    @Override
    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        ItemStack stackAt;
        if (this.buggyType == 0) {
            return ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
        }
        int count = 0;
        for (count = 0; count < this.stacks.size(); ++count) {
            stackAt = (ItemStack)this.stacks.get(count);
            if (stackAt == null || stackAt.func_77973_b() != stack.func_77973_b() || stackAt.func_77952_i() != stack.func_77952_i() || stackAt.func_190916_E() >= stackAt.func_77976_d()) continue;
            if (stackAt.func_190916_E() + stack.func_190916_E() <= stackAt.func_77976_d()) {
                if (doAdd) {
                    stackAt.func_190917_f(stack.func_190916_E());
                    this.func_70296_d();
                }
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            int origSize = stackAt.func_190916_E();
            int surplus = origSize + stack.func_190916_E() - stackAt.func_77976_d();
            if (doAdd) {
                stackAt.func_190920_e(stackAt.func_77976_d());
                this.func_70296_d();
            }
            stack.func_190920_e(surplus);
            if (this.addCargo(stack, doAdd) == ICargoEntity.EnumCargoLoadingState.SUCCESS) {
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            stackAt.func_190920_e(origSize);
            return ICargoEntity.EnumCargoLoadingState.FULL;
        }
        for (count = 0; count < this.stacks.size(); ++count) {
            stackAt = (ItemStack)this.stacks.get(count);
            if (stackAt.func_190926_b()) continue;
            if (doAdd) {
                this.stacks.set(count, (Object)stack);
                this.func_70296_d();
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    @Override
    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stackAt = this.func_70301_a(i);
            if (stackAt == null) continue;
            ItemStack resultStack = stackAt.func_77946_l();
            resultStack.func_190920_e(1);
            if (doRemove) {
                stackAt.func_190918_g(1);
                this.func_70296_d();
            }
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, resultStack);
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, ItemStack.field_190927_a);
    }

    @Override
    public void setPad(IFuelDock pad) {
        this.landingPad = pad;
    }

    @Override
    public IFuelDock getLandingPad() {
        return this.landingPad;
    }

    @Override
    public void onPadDestroyed() {
    }

    @Override
    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntityBuggyFueler;
    }

    public boolean func_145818_k_() {
        return true;
    }

    @Override
    public UUID getOwnerUUID() {
        if (!this.func_184188_bt().isEmpty() && !(this.func_184188_bt().get(0) instanceof EntityPlayer)) {
            return null;
        }
        return !this.func_184188_bt().isEmpty() ? ((Entity)this.func_184188_bt().get(0)).getPersistentID() : null;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCurrentLevel() {
        return this.buggyFuelTank.getFluidAmount();
    }

    @Override
    public int getMaxFuel() {
        return this.buggyFuelTank.getCapacity();
    }

    @Override
    public boolean inFlight() {
        return false;
    }
}

