/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy;

import buildcraft.api.mj.MjAPI;
import java.io.File;
import java.util.ArrayList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraftforge.common.config.Configuration;

public class EnergyConfigHandler {
    private static final boolean cachedBCLoaded = false;
    private static final boolean cachedBCLoadedValue = false;
    private static final int cachedBCVersion = -1;
    public static float BC3_RATIO = 16.0f;
    public static float RF_RATIO = BC3_RATIO / 10.0f;
    public static float TO_RF_RATIO = 1.0f / RF_RATIO;
    public static float TO_RF_RATIOdisp = 1.0f / RF_RATIO;
    public static float IC2_RATIO = BC3_RATIO / 2.44f;
    public static float MEKANISM_RATIO = IC2_RATIO / 10.0f;
    public static float TO_MEKANISM_RATIO = 1.0f / MEKANISM_RATIO;
    public static float TO_MEKANISM_RATIOdisp = 1.0f / MEKANISM_RATIO;
    public static float TO_IC2_RATIO = 1.0f / IC2_RATIO;
    public static float TO_IC2_RATIOdisp = 1.0f / IC2_RATIO;
    public static float TO_BC_RATIOdisp = 1.0f / BC3_RATIO;
    public static Object gasOxygen = null;
    public static Object gasHydrogen = null;
    public static boolean displayEnergyUnitsBC = false;
    public static boolean displayEnergyUnitsIC2 = false;
    public static boolean displayEnergyUnitsMek = false;
    public static boolean displayEnergyUnitsRF = false;
    public static boolean disableBuildCraftInput = false;
    public static boolean disableBuildCraftOutput = false;
    public static boolean disableRFInput = false;
    public static boolean disableRFOutput = false;
    public static boolean disableFEInput = false;
    public static boolean disableFEOutput = false;
    public static boolean disableIC2Input = false;
    public static boolean disableIC2Output = false;
    public static boolean disableMekanismInput = false;
    public static boolean disableMekanismOutput = false;
    private static Configuration config;
    private static float BC8_MICROJOULE_RATIO;
    public static float BC8_INTERNAL_RATIO;
    public static float TO_BC_RATIO;
    private static int conversionLossFactor;
    private static boolean cachedBCRLoaded;
    private static boolean cachedBCRLoadedValue;
    private static boolean cachedRFLoaded;
    private static boolean cachedRFLoadedValue;
    private static boolean cachedRF1LoadedValue;
    private static boolean cachedRF2LoadedValue;
    private static boolean disableMJinterface;

    public static void setDefaultValues(File file) {
        if (config == null) {
            config = new Configuration(file);
        }
        config.load();
        IC2_RATIO = (float)config.get("Compatibility", "IndustrialCraft Conversion Ratio", (double)IC2_RATIO).getDouble((double)IC2_RATIO);
        RF_RATIO = (float)config.get("Compatibility", "RF Conversion Ratio", (double)RF_RATIO).getDouble((double)RF_RATIO);
        BC3_RATIO = (float)config.get("Compatibility", "BuildCraft Conversion Ratio", (double)BC3_RATIO).getDouble((double)BC3_RATIO);
        MEKANISM_RATIO = (float)config.get("Compatibility", "Mekanism Conversion Ratio", (double)MEKANISM_RATIO).getDouble((double)MEKANISM_RATIO);
        conversionLossFactor = config.get("Compatibility", "Loss factor when converting energy as a percentage (100 = no loss, 90 = 10% loss ...)", 100).getInt(100);
        if (conversionLossFactor > 100) {
            conversionLossFactor = 100;
        }
        if (conversionLossFactor < 5) {
            conversionLossFactor = 5;
        }
        EnergyConfigHandler.updateRatios();
        displayEnergyUnitsBC = config.get("Display", "If BuildCraft is loaded, show Galacticraft machines energy as MJ instead of gJ?", false).getBoolean(false);
        displayEnergyUnitsIC2 = config.get("Display", "If IndustrialCraft2 is loaded, show Galacticraft machines energy as EU instead of gJ?", false).getBoolean(false);
        displayEnergyUnitsMek = config.get("Display", "If Mekanism is loaded, show Galacticraft machines energy as Joules (J) instead of gJ?", false).getBoolean(false);
        displayEnergyUnitsRF = config.get("Display", "Show Galacticraft machines energy in RF instead of gJ?", false).getBoolean(false);
        disableMJinterface = config.get("Compatibility", "Disable old Buildcraft API (MJ) interfacing completely?", false).getBoolean(false);
        disableBuildCraftInput = config.get("Compatibility", "Disable INPUT of BuildCraft energy", false).getBoolean(false);
        disableBuildCraftOutput = config.get("Compatibility", "Disable OUTPUT of BuildCraft energy", false).getBoolean(false);
        disableRFInput = config.get("Compatibility", "Disable INPUT of RF energy", false).getBoolean(false);
        disableRFOutput = config.get("Compatibility", "Disable OUTPUT of RF energy", false).getBoolean(false);
        disableFEInput = config.get("Compatibility", "Disable INPUT of Forge Energy to GC machines", false).getBoolean(false);
        disableFEOutput = config.get("Compatibility", "Disable OUTPUT of Forge Energy from GC machines", false).getBoolean(false);
        disableIC2Input = config.get("Compatibility", "Disable INPUT of IC2 energy", false).getBoolean(false);
        disableIC2Output = config.get("Compatibility", "Disable OUTPUT of IC2 energy", false).getBoolean(false);
        disableMekanismInput = config.get("Compatibility", "Disable INPUT of Mekanism energy", false).getBoolean(false);
        disableMekanismOutput = config.get("Compatibility", "Disable OUTPUT of Mekanism energy", false).getBoolean(false);
        if (!EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            displayEnergyUnitsIC2 = false;
        }
        if (!EnergyConfigHandler.isMekanismLoaded()) {
            displayEnergyUnitsMek = false;
        }
        if (displayEnergyUnitsIC2) {
            displayEnergyUnitsBC = false;
        }
        if (displayEnergyUnitsMek) {
            displayEnergyUnitsBC = false;
            displayEnergyUnitsIC2 = false;
        }
        if (displayEnergyUnitsRF) {
            displayEnergyUnitsBC = false;
            displayEnergyUnitsIC2 = false;
            displayEnergyUnitsMek = false;
        }
        config.save();
    }

    public static void initGas() {
        if (EnergyConfigHandler.isMekanismLoaded()) {
            Gas oxygen = GasRegistry.getGas((String)"oxygen");
            gasOxygen = oxygen == null ? GasRegistry.register((Gas)new Gas(GCFluids.fluidOxygenGas)).registerFluid() : oxygen;
            Gas hydrogen = GasRegistry.getGas((String)"hydrogen");
            gasHydrogen = hydrogen == null ? GasRegistry.register((Gas)new Gas(GCFluids.fluidHydrogenGas)).registerFluid() : hydrogen;
        }
    }

    public static boolean isIndustrialCraft2Loaded() {
        return CompatibilityManager.isIc2Loaded();
    }

    public static boolean isBuildcraftLoaded() {
        if (!cachedBCRLoaded) {
            boolean mjAPIFound = false;
            try {
                Class.forName("buildcraft.api.mj.MjAPI");
                mjAPIFound = true;
                BC8_MICROJOULE_RATIO = MjAPI.MJ;
                BC8_INTERNAL_RATIO = BC3_RATIO / BC8_MICROJOULE_RATIO;
                TO_BC_RATIO = (float)conversionLossFactor / 100.0f / BC3_RATIO * BC8_MICROJOULE_RATIO;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            cachedBCRLoaded = true;
            cachedBCRLoadedValue = mjAPIFound && CompatibilityManager.isBCraftEnergyLoaded() && CompatibilityManager.classBCTransportPipeTile != null;
        }
        return cachedBCRLoadedValue;
    }

    public static boolean isRFAPILoaded() {
        if (!cachedRFLoaded) {
            EnergyConfigHandler.initialiseRF();
        }
        return cachedRFLoadedValue;
    }

    public static boolean isRFAPIv1Loaded() {
        if (!cachedRFLoaded) {
            EnergyConfigHandler.initialiseRF();
        }
        return cachedRF1LoadedValue;
    }

    public static boolean isRFAPIv2Loaded() {
        if (!cachedRFLoaded) {
            EnergyConfigHandler.initialiseRF();
        }
        return cachedRF2LoadedValue;
    }

    private static void initialiseRF() {
        cachedRFLoaded = true;
        cachedRFLoadedValue = false;
        cachedRF2LoadedValue = false;
        int count = 0;
        int count2 = 0;
        try {
            if (Class.forName("cofh.redstoneflux.api.IEnergyConnection") != null) {
                ++count;
            }
            if (Class.forName("cofh.redstoneflux.api.IEnergyHandler") != null) {
                count += 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Class.forName("cofh.redstoneflux.api.IEnergyProvider") != null) {
                ++count2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Class.forName("cofh.redstoneflux.api.IEnergyReceiver") != null) {
                ++count2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (count + count2 == 3 && count2 != 1 || count + count2 == 5) {
            cachedRFLoadedValue = true;
            cachedRF1LoadedValue = count == 3;
            cachedRF2LoadedValue = count2 == 2;
        } else if (count > 0 || count2 > 0) {
            GCLog.severe("Incomplete Redstone Flux API detected: Galacticraft will not support RF energy connections until this is fixed.");
        }
    }

    public static boolean isMekanismLoaded() {
        return CompatibilityManager.isMekanismLoaded();
    }

    private static void updateRatios() {
        if (IC2_RATIO < 0.01f) {
            IC2_RATIO = 0.01f;
        }
        if (RF_RATIO < 0.001f) {
            RF_RATIO = 0.001f;
        }
        if (BC3_RATIO < 0.01f) {
            BC3_RATIO = 0.01f;
        }
        if (MEKANISM_RATIO < 0.001f) {
            MEKANISM_RATIO = 0.001f;
        }
        if (IC2_RATIO > 1000.0f) {
            IC2_RATIO = 1000.0f;
        }
        if (RF_RATIO > 100.0f) {
            RF_RATIO = 100.0f;
        }
        if (BC3_RATIO > 1000.0f) {
            BC3_RATIO = 1000.0f;
        }
        if (MEKANISM_RATIO > 100.0f) {
            MEKANISM_RATIO = 100.0f;
        }
        float factor = (float)conversionLossFactor / 100.0f;
        TO_BC_RATIO = factor / BC3_RATIO * BC8_MICROJOULE_RATIO;
        TO_RF_RATIO = factor / RF_RATIO;
        TO_IC2_RATIO = factor / IC2_RATIO;
        TO_MEKANISM_RATIO = factor / MEKANISM_RATIO;
        TO_BC_RATIOdisp = 1.0f / BC3_RATIO;
        TO_RF_RATIOdisp = 1.0f / RF_RATIO;
        TO_IC2_RATIOdisp = 1.0f / IC2_RATIO;
        TO_MEKANISM_RATIOdisp = 1.0f / MEKANISM_RATIO;
        BC3_RATIO *= factor;
        RF_RATIO *= factor;
        IC2_RATIO *= factor;
        MEKANISM_RATIO *= factor;
    }

    public static void serverConfigOverride(ArrayList<Object> returnList) {
        returnList.add(Float.valueOf(BC3_RATIO));
        returnList.add(Float.valueOf(RF_RATIO));
        returnList.add(Float.valueOf(IC2_RATIO));
        returnList.add(Float.valueOf(MEKANISM_RATIO));
        returnList.add(conversionLossFactor);
    }

    public static void setConfigOverride(float sBC3, float sRF, float sIC2, float sMEK, int sLossRatio) {
        BC3_RATIO = sBC3;
        RF_RATIO = sRF;
        IC2_RATIO = sIC2;
        MEKANISM_RATIO = sMEK;
        conversionLossFactor = sLossRatio;
        EnergyConfigHandler.updateRatios();
    }

    static {
        BC8_MICROJOULE_RATIO = 1000000.0f;
        BC8_INTERNAL_RATIO = BC3_RATIO / BC8_MICROJOULE_RATIO;
        TO_BC_RATIO = 1.0f / BC3_RATIO * BC8_MICROJOULE_RATIO;
        conversionLossFactor = 100;
        cachedBCRLoaded = false;
        cachedBCRLoadedValue = false;
        cachedRFLoaded = false;
        cachedRFLoadedValue = false;
        cachedRF1LoadedValue = false;
        cachedRF2LoadedValue = false;
        disableMJinterface = false;
    }
}

