/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IOxygenReliantBlock;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockTorchBase;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockUnlitTorch
extends BlockTorchBase
implements IOxygenReliantBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", facing -> facing != EnumFacing.DOWN);
    public static HashMap<Block, Block> registeredTorches = new HashMap();
    public boolean lit;
    public Block litVersion;
    public Block unlitVersion;
    public Block fallback;

    public BlockUnlitTorch(boolean lit, String assetName) {
        super(Material.field_151594_q);
        this.func_149675_a(true);
        this.lit = lit;
        this.func_149715_a(lit ? 0.9375f : 0.2f);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c(assetName);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
    }

    public static void register(BlockUnlitTorch unlittorch, BlockUnlitTorch littorch, Block vanillatorch) {
        littorch.litVersion = littorch;
        littorch.unlitVersion = unlittorch;
        littorch.fallback = vanillatorch;
        unlittorch.litVersion = littorch;
        unlittorch.unlitVersion = unlittorch;
        unlittorch.fallback = vanillatorch;
        registeredTorches.put(littorch, vanillatorch);
        GCBlocks.itemChanges.put(unlittorch, littorch);
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (state.func_177230_c().func_176201_c(state) == 0) {
            this.func_176213_c(worldIn, pos, state);
        } else {
            this.checkOxygen(worldIn, pos, state);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (this.checkForDrop(worldIn, pos, state)) {
            this.checkOxygen(worldIn, pos, state);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkForDrop(worldIn, pos, state)) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            EnumFacing.Axis enumfacingAxis = enumfacing.func_176740_k();
            EnumFacing enumfacing1 = enumfacing.func_176734_d();
            boolean flag = false;
            if (enumfacingAxis.func_176722_c() && !worldIn.isSideSolid(pos.func_177972_a(enumfacing1), enumfacing, true)) {
                flag = true;
            } else if (enumfacingAxis.func_176720_b() && !this.canPlaceOn(worldIn, pos.func_177972_a(enumfacing1))) {
                flag = true;
            }
            if (flag) {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            } else {
                this.checkOxygen(worldIn, pos, state);
            }
        }
    }

    private void checkOxygen(World world, BlockPos pos, IBlockState state) {
        if (world.field_73011_w instanceof IGalacticraftWorldProvider) {
            if (OxygenUtil.checkTorchHasOxygen(world, pos)) {
                this.onOxygenAdded(world, pos, state);
            } else {
                this.onOxygenRemoved(world, pos, state);
            }
        } else {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            world.func_180501_a(pos, this.fallback.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7;
        double d2 = (double)pos.func_177952_p() + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        if (enumfacing.func_176740_k().func_176722_c()) {
            EnumFacing enumfacing1 = enumfacing.func_176734_d();
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4 * (double)enumfacing1.func_82601_c(), d1 + d3, d2 + d4 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            if (this == GCBlocks.unlitTorchLit) {
                worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4 * (double)enumfacing1.func_82601_c(), d1 + d3, d2 + d4 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            if (this == GCBlocks.unlitTorchLit) {
                worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public void onOxygenRemoved(World world, BlockPos pos, IBlockState state) {
        if (world.field_73011_w instanceof IGalacticraftWorldProvider) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            world.func_180501_a(pos, this.unlitVersion.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    @Override
    public void onOxygenAdded(World world, BlockPos pos, IBlockState state) {
        if (world.field_73011_w instanceof IGalacticraftWorldProvider) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            world.func_180501_a(pos, this.litVersion.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(this.litVersion));
        return ret;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

