/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.block.IPlantableBlock;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBasicMoon
extends Block
implements IDetectableResource,
IPlantableBlock,
ITerraformableBlock,
ISortableBlock {
    public static final PropertyEnum<EnumBlockBasicMoon> BASIC_TYPE_MOON = PropertyEnum.func_177709_a((String)"basictypemoon", EnumBlockBasicMoon.class);

    public BlockBasicMoon(String assetName) {
        super(Material.field_151576_e);
        this.field_149782_v = 1.5f;
        this.field_149781_w = 2.5f;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BASIC_TYPE_MOON, (Comparable)((Object)EnumBlockBasicMoon.ORE_COPPER_MOON)));
        this.func_149663_c(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        EnumBlockBasicMoon type = (EnumBlockBasicMoon)((Object)world.func_180495_p(pos).func_177229_b(BASIC_TYPE_MOON));
        if (type == EnumBlockBasicMoon.MOON_DUNGEON_BRICK) {
            return 40.0f;
        }
        if (type == EnumBlockBasicMoon.MOON_STONE) {
            return 6.0f;
        }
        if (type == EnumBlockBasicMoon.ORE_COPPER_MOON || type == EnumBlockBasicMoon.ORE_TIN_MOON || type == EnumBlockBasicMoon.ORE_SAPPHIRE || type == EnumBlockBasicMoon.ORE_CHEESE_MOON) {
            return 3.0f;
        }
        return this.field_149781_w / 5.0f;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        EnumBlockBasicMoon type = (EnumBlockBasicMoon)((Object)worldIn.func_180495_p(pos).func_177229_b(BASIC_TYPE_MOON));
        if (type == EnumBlockBasicMoon.MOON_DIRT || type == EnumBlockBasicMoon.MOON_TURF) {
            return 0.5f;
        }
        if (type == EnumBlockBasicMoon.MOON_DUNGEON_BRICK) {
            return 4.0f;
        }
        if (type == EnumBlockBasicMoon.ORE_COPPER_MOON || type == EnumBlockBasicMoon.ORE_TIN_MOON || type == EnumBlockBasicMoon.ORE_SAPPHIRE) {
            return 5.0f;
        }
        if (type == EnumBlockBasicMoon.ORE_CHEESE_MOON) {
            return 3.0f;
        }
        return this.field_149782_v;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        EnumBlockBasicMoon type = (EnumBlockBasicMoon)((Object)world.func_180495_p(pos).func_177229_b(BASIC_TYPE_MOON));
        if (type == EnumBlockBasicMoon.MOON_DIRT || type == EnumBlockBasicMoon.MOON_TURF) {
            return true;
        }
        return super.canHarvestBlock(world, pos, player);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        EnumBlockBasicMoon type = (EnumBlockBasicMoon)((Object)state.func_177229_b(BASIC_TYPE_MOON));
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        EnumBlockBasicMoon type = (EnumBlockBasicMoon)((Object)state.func_177229_b(BASIC_TYPE_MOON));
        if (type == EnumBlockBasicMoon.ORE_CHEESE_MOON) {
            return 0;
        }
        if (type == EnumBlockBasicMoon.ORE_SAPPHIRE) {
            return 2;
        }
        return this.func_176201_c(state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        EnumBlockBasicMoon type = (EnumBlockBasicMoon)((Object)state.func_177229_b(BASIC_TYPE_MOON));
        switch (type) {
            case ORE_CHEESE_MOON: {
                if (fortune >= 1) {
                    return random.nextFloat() < (float)fortune * 0.29f - 0.25f ? 2 : 1;
                }
                return 1;
            }
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumBlockBasicMoon type : EnumBlockBasicMoon.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    @Override
    public boolean isValueable(IBlockState state) {
        EnumBlockBasicMoon type = (EnumBlockBasicMoon)((Object)state.func_177229_b(BASIC_TYPE_MOON));
        switch (type) {
            case ORE_CHEESE_MOON: 
            case ORE_COPPER_MOON: 
            case ORE_SAPPHIRE: 
            case ORE_TIN_MOON: {
                return true;
            }
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumBlockBasicMoon type = (EnumBlockBasicMoon)((Object)world.func_180495_p(pos).func_177229_b(BASIC_TYPE_MOON));
        if (type != EnumBlockBasicMoon.MOON_TURF) {
            return false;
        }
        plantable.getPlant(world, pos.func_177972_a(EnumFacing.UP));
        return plantable instanceof BlockFlower;
    }

    @Override
    public int requiredLiquidBlocksNearby() {
        return 4;
    }

    @Override
    public boolean isPlantable(IBlockState state) {
        return state.func_177229_b(BASIC_TYPE_MOON) == EnumBlockBasicMoon.MOON_TURF;
    }

    @Override
    public boolean isTerraformable(World world, BlockPos pos) {
        EnumBlockBasicMoon type = (EnumBlockBasicMoon)((Object)world.func_180495_p(pos).func_177229_b(BASIC_TYPE_MOON));
        if (type == EnumBlockBasicMoon.MOON_TURF) {
            BlockPos above = pos.func_177972_a(EnumFacing.UP);
            IBlockState stateAbove = world.func_180495_p(above);
            return stateAbove.func_177230_c().isAir(stateAbove, (IBlockAccess)world, above);
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        EnumBlockBasicMoon type = (EnumBlockBasicMoon)((Object)state.func_177229_b(BASIC_TYPE_MOON));
        if (!worldIn.field_72995_K && type == EnumBlockBasicMoon.MOON_TURF) {
            long chunkKey;
            List<Footprint> footprintList;
            Map<Long, List<Footprint>> footprintChunkMap = TickHandlerServer.serverFootprintMap.get(GCCoreUtil.getDimensionID(worldIn));
            if (footprintChunkMap != null && (footprintList = footprintChunkMap.get(chunkKey = ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4)))) != null && !footprintList.isEmpty()) {
                ArrayList<Footprint> toRemove = new ArrayList<Footprint>();
                for (Footprint footprint : footprintList) {
                    if (!(footprint.position.x > (double)pos.func_177958_n()) || !(footprint.position.x < (double)(pos.func_177958_n() + 1)) || !(footprint.position.z > (double)pos.func_177952_p()) || !(footprint.position.z < (double)(pos.func_177952_p() + 1))) continue;
                    toRemove.add(footprint);
                }
                if (!toRemove.isEmpty()) {
                    footprintList.removeAll(toRemove);
                }
            }
            TickHandlerServer.footprintBlockChanges.add(new BlockVec3Dim(pos, GCCoreUtil.getDimensionID(worldIn)));
        }
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        EnumBlockBasicMoon type = (EnumBlockBasicMoon)((Object)world.func_180495_p(pos).func_177229_b(BASIC_TYPE_MOON));
        return type == EnumBlockBasicMoon.MOON_STONE || type == EnumBlockBasicMoon.MOON_DIRT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BASIC_TYPE_MOON, (Comparable)((Object)EnumBlockBasicMoon.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBlockBasicMoon)((Object)state.func_177229_b(BASIC_TYPE_MOON))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BASIC_TYPE_MOON});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        EnumBlockBasicMoon type = (EnumBlockBasicMoon)((Object)this.func_176203_a(meta).func_177229_b(BASIC_TYPE_MOON));
        switch (type) {
            case ORE_CHEESE_MOON: 
            case ORE_COPPER_MOON: 
            case ORE_SAPPHIRE: 
            case ORE_TIN_MOON: {
                return EnumSortCategoryBlock.ORE;
            }
            case MOON_DUNGEON_BRICK: {
                return EnumSortCategoryBlock.BRICKS;
            }
        }
        return EnumSortCategoryBlock.GENERAL;
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        int meta = this.func_176201_c(state);
        if (meta == 2 || meta == 6) {
            Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
            return MathHelper.func_76136_a((Random)rand, (int)2, (int)5) + (meta == 6 ? 1 : 0);
        }
        return 0;
    }

    public static enum EnumBlockBasicMoon implements IStringSerializable
    {
        ORE_COPPER_MOON(0, "ore_copper_moon"),
        ORE_TIN_MOON(1, "ore_tin_moon"),
        ORE_CHEESE_MOON(2, "ore_cheese_moon"),
        MOON_DIRT(3, "moon_dirt_moon"),
        MOON_STONE(4, "moon_stone"),
        MOON_TURF(5, "moon_turf"),
        ORE_SAPPHIRE(6, "ore_sapphire_moon"),
        MOON_DUNGEON_BRICK(14, "moon_dungeon_brick");

        private static final EnumBlockBasicMoon[] values;
        private final int meta;
        private final String name;

        private EnumBlockBasicMoon(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumBlockBasicMoon byMetadata(int meta) {
            if (meta < 7) {
                return values[meta];
            }
            return MOON_DUNGEON_BRICK;
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumBlockBasicMoon.values();
        }
    }
}

