/*
 * Decompiled with CFR 0.152.
 */
package net.yseven.findyourway.Network;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.yseven.findyourway.item.ItemCompassBase;

public class MessageToClient
implements IMessage {
    private ItemCompassBase compass;
    private BlockPos structurePos;
    private boolean messageIsValid;

    public boolean isMessageIsValid() {
        return this.messageIsValid;
    }

    public ItemCompassBase getCompass() {
        return this.compass;
    }

    public BlockPos getStructurePos() {
        return this.structurePos;
    }

    public MessageToClient() {
        this.messageIsValid = false;
    }

    public MessageToClient(BlockPos pos, ItemCompassBase compassBase) {
        this.structurePos = pos;
        this.compass = compassBase;
        this.messageIsValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            this.structurePos = new BlockPos(x, y, z);
            this.compass = ItemCompassBase.fromBytes(buf);
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Error while reading MessageToClient: " + ioe);
            return;
        }
        this.messageIsValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.isMessageIsValid()) {
            return;
        }
        buf.writeDouble((double)this.structurePos.func_177958_n());
        buf.writeDouble((double)this.structurePos.func_177956_o());
        buf.writeDouble((double)this.structurePos.func_177952_p());
        this.compass.toBytes(buf);
    }

    public String toString() {
        return "Structure Position is: " + this.structurePos.toString() + "!";
    }
}

