/*
 * Decompiled with CFR 0.152.
 */
package de.lathanael.facadepainter.integration.jei;

import crazypants.enderio.base.conduit.facade.ItemConduitFacade;
import de.lathanael.facadepainter.init.ItemRegistry;
import de.lathanael.facadepainter.integration.ModIntegration;
import de.lathanael.facadepainter.integration.jei.FacadeClearingRecipe;
import de.lathanael.facadepainter.integration.jei.FacadeClearingRecipeWrapper;
import de.lathanael.facadepainter.integration.jei.FacadePaintingRecipe;
import de.lathanael.facadepainter.integration.jei.FacadePaintingRecipeCategory;
import de.lathanael.facadepainter.integration.jei.FacadePaintingRecipeWrapper;
import de.lathanael.facadepainter.network.SyncedConfig;
import de.lathanael.facadepainter.recipes.ToggleableShapelessRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@JEIPlugin
public class JEIFacadePainterPlugin
implements IModPlugin {
    public static JEIFacadePainterPlugin instance;
    private IJeiRuntime jeiRuntime;
    private IModRegistry jeiModRegistry;
    private List<Object> toggleableShapelessRecipes = new ArrayList<Object>();

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new FacadePaintingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void register(@Nonnull IModRegistry registry) {
        instance = this;
        this.jeiModRegistry = registry;
        ModIntegration.preInitJEI(registry);
        if (!SyncedConfig.enableChamaeleoPaint) {
            this.jeiModRegistry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegistry.itemChamaeleoPaint));
        }
        registry.addRecipes(ModIntegration.recipeList.getPseudoClearingRecipeList(), "minecraft.crafting");
        registry.handleRecipes(FacadeClearingRecipe.class, recipe -> new FacadeClearingRecipeWrapper((FacadeClearingRecipe)recipe), "minecraft.crafting");
        registry.addRecipes(ModIntegration.recipeList.getRecipeList(), "facadepainter.crafting");
        registry.handleRecipes(FacadePaintingRecipe.class, recipe -> new FacadePaintingRecipeWrapper((FacadePaintingRecipe)recipe), "facadepainter.crafting");
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        this.jeiRuntime = runtime;
        for (Map.Entry recipeEntry : ForgeRegistries.RECIPES.getEntries()) {
            IRecipe recipe = (IRecipe)recipeEntry.getValue();
            if (!(recipe instanceof ToggleableShapelessRecipe)) continue;
            this.toggleableShapelessRecipes.add(recipe);
            if (!SyncedConfig.enableChamaeleoPaint && !(recipe.func_77571_b().func_77973_b() instanceof ItemConduitFacade)) {
                this.jeiRuntime.getRecipeRegistry().hideRecipe(this.jeiRuntime.getRecipeRegistry().getRecipeWrapper((Object)recipe, "minecraft.crafting"), "minecraft.crafting");
            }
            if (!(recipe.func_77571_b().func_77973_b() instanceof ItemConduitFacade)) continue;
            this.jeiRuntime.getRecipeRegistry().hideRecipe(this.jeiRuntime.getRecipeRegistry().getRecipeWrapper((Object)recipe, "minecraft.crafting"), "minecraft.crafting");
        }
        for (Object recipeWrapper : this.jeiRuntime.getRecipeRegistry().getRecipeWrappers(this.jeiRuntime.getRecipeRegistry().getRecipeCategory("minecraft.crafting"))) {
            if (!(recipeWrapper instanceof FacadeClearingRecipeWrapper)) continue;
            this.toggleableShapelessRecipes.add(recipeWrapper);
            if (SyncedConfig.enableShapelessClearingRecipe) continue;
            this.jeiRuntime.getRecipeRegistry().hideRecipe((IRecipeWrapper)((FacadeClearingRecipeWrapper)recipeWrapper), "minecraft.crafting");
        }
        if (SyncedConfig.hideJEIFacadePaintingRecipeCategory) {
            this.jeiRuntime.getRecipeRegistry().hideRecipeCategory("facadepainter.crafting");
        }
    }

    public IJeiRuntime getJEIRuntime() {
        return this.jeiRuntime;
    }

    public IModRegistry getJEIModRegistry() {
        return this.jeiModRegistry;
    }

    public List<Object> getToggleableShapelessRecipes() {
        return this.toggleableShapelessRecipes;
    }
}

