/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.textures;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.compatibility.TextureAtlasSpriteCompat;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;

public abstract class SpriteLoader
extends TextureAtlasSpriteCompat {
    public SpriteLoader(String spriteName) {
        super(spriteName);
    }

    public final boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    @Override
    public abstract boolean load(IResourceManager var1, ResourceLocation var2);

    protected void loadSprite(BufferedImage[] images, AnimationMetadataSection meta) {
        Object bufferedimage;
        int i = images[0].getWidth();
        int j = images[0].getHeight();
        this.field_130223_c = i;
        this.field_130224_d = j;
        int[][] aint = new int[images.length][];
        for (int k = 0; k < images.length; ++k) {
            bufferedimage = images[k];
            if (bufferedimage == null) continue;
            if (k > 0 && (((BufferedImage)bufferedimage).getWidth() != i >> k || ((BufferedImage)bufferedimage).getHeight() != j >> k)) {
                throw new RuntimeException(String.format("Unable to load miplevel: %d, image is size: %dx%d, expected %dx%d", k, ((BufferedImage)bufferedimage).getWidth(), ((BufferedImage)bufferedimage).getHeight(), i >> k, j >> k));
            }
            aint[k] = new int[((BufferedImage)bufferedimage).getWidth() * ((BufferedImage)bufferedimage).getHeight()];
            ((BufferedImage)bufferedimage).getRGB(0, 0, ((BufferedImage)bufferedimage).getWidth(), ((BufferedImage)bufferedimage).getHeight(), aint[k], 0, ((BufferedImage)bufferedimage).getWidth());
        }
        if (meta == null) {
            if (j != i) {
                throw new RuntimeException("broken aspect ratio and not an animation");
            }
            this.field_110976_a.add(aint);
        } else {
            int j1 = j / i;
            this.field_130224_d = this.field_130223_c;
            if (meta.func_110473_c() > 0) {
                bufferedimage = meta.func_130073_e().iterator();
                while (bufferedimage.hasNext()) {
                    int i1 = (Integer)bufferedimage.next();
                    if (i1 >= j1) {
                        throw new RuntimeException("invalid frameindex " + i1);
                    }
                    this.func_130099_d(i1);
                    this.field_110976_a.set(i1, SpriteLoader.func_147962_a((int[][])aint, (int)i, (int)i, (int)i1));
                }
                this.field_110982_k = meta;
            } else {
                ArrayList list = Lists.newArrayList();
                for (int l1 = 0; l1 < j1; ++l1) {
                    this.field_110976_a.add(SpriteLoader.func_147962_a((int[][])aint, (int)i, (int)i, (int)l1));
                    list.add(new AnimationFrame(l1, -1));
                }
                this.field_110982_k = new AnimationMetadataSection((List)list, this.field_130223_c, this.field_130224_d, meta.func_110469_d(), meta.func_177219_e());
            }
        }
    }

    public void func_188538_a(PngSizeInfo sizeInfo, boolean p_188538_2_) throws IOException {
        super.func_188538_a(sizeInfo, p_188538_2_);
    }

    public void func_188539_a(IResource resource, int p_188539_2_) throws IOException {
        BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
        int[][] aint = new int[p_188539_2_][];
        aint[0] = new int[bufferedimage.getWidth() * bufferedimage.getHeight()];
        bufferedimage.getRGB(0, 0, bufferedimage.getWidth(), bufferedimage.getHeight(), aint[0], 0, bufferedimage.getWidth());
        this.field_110976_a.add(aint);
    }
}

