/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.quarry;

import com.broulf.netherbackport.block.BlockCryingObsidian;
import com.rwtema.extrautils2.quarry.TileQuarryProxy;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileQuarry
extends TileEntity
implements ITickable {
    public static final int DESIRED_STACKS = 9;
    public static final int STACK_SIZE = 64;
    public static final int DESIRED_COUNT = 576;
    public static final int TICKS_BETWEEN_OPERATIONS = 2;
    public static final int ENERGY_PER_OPERATION = 100000000;
    public static final int MAX_ENERGY_STORAGE = Integer.MAX_VALUE;
    private final ItemStackHandler inventory = new ItemStackHandler(1);
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(Integer.MAX_VALUE);
    private int tickCounter = 0;
    @CapabilityInject(value=IEnergyStorage.class)
    public static Capability<IEnergyStorage> ENERGY_CAPABILITY = null;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.hasNearbyBlocks()) {
            return;
        }
        if (this.energyStorage.extractEnergy(100000000, false) != 100000000) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 2 == 0) {
            this.maintainOutputChest();
        }
    }

    private void maintainOutputChest() {
        TileEntity topProxy = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (!(topProxy instanceof TileQuarryProxy)) {
            return;
        }
        if (((TileQuarryProxy)topProxy).facing.value != EnumFacing.DOWN) {
            return;
        }
        BlockPos chestPos = this.field_174879_c.func_177981_b(2);
        TileEntity chestTE = this.field_145850_b.func_175625_s(chestPos);
        if (chestTE == null) {
            return;
        }
        IItemHandler handler = (IItemHandler)chestTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
        if (handler == null) {
            handler = (IItemHandler)chestTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        if (handler == null) {
            return;
        }
        int current = 0;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            current += handler.getStackInSlot(slot).func_190916_E();
        }
        int needed = 576 - current;
        if (needed <= 0) {
            return;
        }
        ItemStack toInsert = new ItemStack(BlockCryingObsidian.block, needed);
        for (int slot = 0; slot < handler.getSlots() && !(toInsert = handler.insertItem(slot, toInsert, false)).func_190926_b(); ++slot) {
        }
    }

    public boolean hasNearbyBlocks() {
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tileEntity != null && tileEntity instanceof TileQuarryProxy && ((TileQuarryProxy)tileEntity).facing.value == facing.func_176734_d()) continue;
            return false;
        }
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74782_a("Energy", (NBTBase)this.energyStorage.serializeNBT());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        this.energyStorage.deserializeNBT(compound.func_74775_l("Energy"));
    }

    private static class CustomEnergyStorage
    implements IEnergyStorage {
        private int energy;
        private final int capacity;

        public CustomEnergyStorage(int capacity) {
            this.capacity = capacity;
            this.energy = 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int energyReceived = Math.min(this.capacity - this.energy, maxReceive);
            if (!simulate) {
                this.energy += energyReceived;
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int energyExtracted = Math.min(this.energy, maxExtract);
            if (!simulate) {
                this.energy -= energyExtracted;
            }
            return energyExtracted;
        }

        public int getEnergyStored() {
            return this.energy;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Energy", this.energy);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.energy = nbt.func_74762_e("Energy");
        }
    }
}

