/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.monitor;

import crazypants.enderio.base.render.util.DynaTextureProvider;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DynaTextureProviderPMon
extends DynaTextureProvider {
    public static final int TEXSIZE = 32;
    @Nonnull
    protected static final ResourceLocation pmon_screen = new ResourceLocation("enderio", "textures/blocks/block_pm_on_screen.png");
    @Nonnull
    protected static final int[] pmon_screen_data = new int[1024];
    @Nonnull
    protected static final ResourceLocation pmon_color = new ResourceLocation("enderio", "textures/blocks/block_pm_on_color.png");
    @Nonnull
    protected static final int[] pmon_color_data = new int[1024];
    @Nonnull
    protected static final ResourceLocation pmon_fallback = new ResourceLocation("enderio", "textures/blocks/block_pm_on.png");
    @Nonnull
    protected final IDataProvider owner;
    protected static boolean texturesLoaded = false;

    public DynaTextureProviderPMon(@Nonnull IDataProvider owner) {
        super(32, pmon_fallback);
        this.owner = owner;
        this.loadStaticTextureData();
        this.updateTexture();
    }

    protected void loadStaticTextureData() {
        if (!texturesLoaded) {
            BufferedImage pmon_color_image;
            BufferedImage pmon_screen_image = this.getTexture(pmon_screen);
            if (pmon_screen_image != null) {
                pmon_screen_image = this.resize(pmon_screen_image, 32);
                pmon_screen_image.getRGB(0, 0, 32, 32, pmon_screen_data, 0, 32);
            }
            if ((pmon_color_image = this.getTexture(pmon_color)) != null) {
                pmon_color_image = this.resize(pmon_color_image, 32);
                pmon_color_image.getRGB(0, 0, 32, 32, pmon_color_data, 0, 32);
            }
            texturesLoaded = true;
        }
    }

    public void updateTextureData() {
        int[][] minmax = this.owner.getIconValues();
        for (int x = 0; x < 32; ++x) {
            for (int y = 0; y < 32; ++y) {
                this.imageData[y * 32 + x] = (x > 27 || 32 - y > minmax[1][x] * 23 / 63 + 5 || 32 - y < minmax[0][x] * 23 / 63 + 5 ? pmon_screen_data : pmon_color_data)[y * 32 + x];
            }
        }
    }

    public static interface IDataProvider {
        @Nonnull
        public BlockPos getLocation();

        @Nonnull
        public int[][] getIconValues();
    }
}

