/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.util;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.api.client.render.IWidgetMap;
import com.enderio.core.client.render.RenderUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class AtlasWidgetIcon
implements IWidgetIcon {
    @Nonnull
    private final IWidgetMap map;
    @Nonnull
    private final TextureAtlasSprite sprite;

    public AtlasWidgetIcon(final @Nonnull TextureAtlasSprite sprite) {
        this.sprite = sprite;
        this.map = new IWidgetMap.WidgetMapImpl(0, TextureMap.field_110575_b){

            public void render(@Nonnull IWidgetIcon widget, double x, double y, double width, double height, double zLevel, boolean doDraw, boolean flipY) {
                BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
                if (doDraw) {
                    RenderUtil.bindTexture((ResourceLocation)this.getTexture());
                    tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                }
                double minU = sprite.func_94209_e();
                double maxU = sprite.func_94212_f();
                double minV = sprite.func_94206_g();
                double maxV = sprite.func_94210_h();
                if (flipY) {
                    tes.func_181662_b(x, y + height, zLevel).func_187315_a(minU, minV).func_181675_d();
                    tes.func_181662_b(x + width, y + height, zLevel).func_187315_a(maxU, minV).func_181675_d();
                    tes.func_181662_b(x + width, y + 0.0, zLevel).func_187315_a(maxU, maxV).func_181675_d();
                    tes.func_181662_b(x, y + 0.0, zLevel).func_187315_a(minU, maxV).func_181675_d();
                } else {
                    tes.func_181662_b(x, y + height, zLevel).func_187315_a(minU, maxV).func_181675_d();
                    tes.func_181662_b(x + width, y + height, zLevel).func_187315_a(maxU, maxV).func_181675_d();
                    tes.func_181662_b(x + width, y + 0.0, zLevel).func_187315_a(maxU, minV).func_181675_d();
                    tes.func_181662_b(x, y + 0.0, zLevel).func_187315_a(minU, minV).func_181675_d();
                }
                IWidgetIcon overlay = widget.getOverlay();
                if (overlay != null) {
                    overlay.getMap().render(overlay, x, y, width, height, zLevel, false, flipY);
                }
                if (doDraw) {
                    Tessellator.func_178181_a().func_78381_a();
                }
            }
        };
    }

    public int getX() {
        return this.sprite.func_130010_a();
    }

    public int getY() {
        return this.sprite.func_110967_i();
    }

    public int getWidth() {
        return this.sprite.func_94211_a();
    }

    public int getHeight() {
        return this.sprite.func_94216_b();
    }

    @Nullable
    public IWidgetIcon getOverlay() {
        return null;
    }

    @Nonnull
    public IWidgetMap getMap() {
        return this.map;
    }
}

