/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.xp;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.xp.XpUtil;
import crazypants.enderio.util.MathUtil;
import info.loenwind.autoconfig.factory.IValue;
import io.netty.buffer.ByteBuf;
import java.security.InvalidParameterException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;

public class ExperienceContainer
extends FluidTank {
    public static final long MAX_XP_POINTS = XpUtil.liquidToExperience(Long.MAX_VALUE);
    @Nonnull
    public static IValue<Fluid> XP = Fluids.XP_JUICE::getFluid;
    private long experienceTotal;
    private boolean xpDirty;
    private final long maxXp;

    public ExperienceContainer() {
        this(Long.MAX_VALUE);
    }

    public ExperienceContainer(long maxStored) {
        super(null, 0);
        this.maxXp = Math.min(maxStored, MAX_XP_POINTS);
    }

    public long getMaximumExperience() {
        return this.maxXp;
    }

    public int getExperienceLevel() {
        return XpUtil.getLevelForExperience(this.experienceTotal);
    }

    public float getExperience() {
        return (float)(this.experienceTotal - XpUtil.getExperienceForLevelL(this.getExperienceLevel())) / (float)this.getXpBarCapacity();
    }

    public int getExperienceTotalIntLimited() {
        return MathUtil.limit(this.experienceTotal);
    }

    public long getExperienceTotal() {
        return this.experienceTotal;
    }

    public boolean isDirty() {
        return this.xpDirty;
    }

    public void setDirty(boolean isDirty) {
        this.xpDirty = isDirty;
    }

    public void set(@Nonnull ExperienceContainer xpCon) {
        this.experienceTotal = xpCon.experienceTotal;
        this.onContentsChanged();
    }

    public int addExperience(int xpToAdd) {
        return MathUtil.limit(this.addExperience((long)xpToAdd));
    }

    public long addExperience(long xpToAdd) {
        long j = MathUtil.clamp(xpToAdd, 0L, this.maxXp - this.experienceTotal);
        this.experienceTotal += j;
        this.xpDirty = true;
        this.onContentsChanged();
        return j;
    }

    public int removeExperience(int xpToRemove) {
        return MathUtil.limit(this.removeExperience((long)xpToRemove));
    }

    public long removeExperience(long xpToRemove) {
        long j = MathUtil.clamp(xpToRemove, 0L, this.experienceTotal);
        this.experienceTotal -= j;
        this.xpDirty = true;
        this.onContentsChanged();
        return j;
    }

    private int getXpBarCapacity() {
        return XpUtil.getXpBarCapacity(this.getExperienceLevel());
    }

    public int getXpBarScaled(int scale) {
        int result = (int)(this.getExperience() * (float)scale);
        return result;
    }

    public void givePlayerXp(@Nonnull EntityPlayer player, int levels) throws XpUtil.TooManyXPLevelsException {
        for (int i = 0; i < levels && this.experienceTotal > 0L; ++i) {
            this.givePlayerXpLevel(player);
        }
    }

    public void givePlayerXpLevel(@Nonnull EntityPlayer player) throws XpUtil.TooManyXPLevelsException {
        long currentXP = XpUtil.getPlayerXPL(player);
        long nextLevelXP = XpUtil.getExperienceForLevelL(player.field_71068_ca + 1);
        long requiredXP = nextLevelXP - currentXP;
        XpUtil.addPlayerXP(player, this.removeExperience(requiredXP));
    }

    public void drainPlayerXpToReachContainerLevel(@Nonnull EntityPlayer player, int level) throws XpUtil.TooManyXPLevelsException {
        if (level >= 0 && level <= XpUtil.getMaxLevelsStorable()) {
            long targetXP = XpUtil.getExperienceForLevelL(level);
            long requiredXP = targetXP - this.experienceTotal;
            if (requiredXP <= 0L) {
                return;
            }
            long drainXP = Math.min(requiredXP, XpUtil.getPlayerXPL(player));
            this.addExperience(drainXP);
            XpUtil.addPlayerXP(player, -drainXP);
        } else {
            Log.info("Invalid Call to drainPlayerXpToReachContainerLevel(), target level of ", level, " is out of range.");
        }
    }

    public void drainPlayerXpToReachPlayerLevel(@Nonnull EntityPlayer player, int level) throws XpUtil.TooManyXPLevelsException {
        if (level >= 0 && level <= XpUtil.getMaxLevelsStorable()) {
            long targetXP = XpUtil.getExperienceForLevelL(level);
            long drainXP = XpUtil.getPlayerXPL(player) - targetXP;
            if (drainXP <= 0L) {
                return;
            }
            if ((drainXP = this.addExperience(drainXP)) > 0L) {
                XpUtil.addPlayerXP(player, -drainXP);
            }
        } else {
            Log.info("Invalid Call to drainPlayerXpToReachPlayerLevel(), target level of ", level, " is out of range.");
        }
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        long available = this.getFluidAmountL();
        long toDrain = Math.min(available, (long)maxDrain);
        long xpAskedToExtract = XpUtil.liquidToExperience(toDrain);
        int fluidToExtract = MathUtil.limit(XpUtil.experienceToLiquid(xpAskedToExtract));
        long xpToExtract = XpUtil.liquidToExperience(fluidToExtract);
        if (doDrain) {
            long newXp = this.experienceTotal - xpToExtract;
            this.experienceTotal = 0L;
            this.addExperience(newXp);
        }
        return new FluidStack((Fluid)XP.get(), fluidToExtract);
    }

    public boolean canFill(EnumFacing from, Fluid fluidIn) {
        return this.canFill() && fluidIn != null && FluidUtil.areFluidsTheSame((Fluid)fluidIn, (Fluid)((Fluid)XP.get()));
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        long xpSpace;
        if (resource == null) {
            return 0;
        }
        if (resource.amount <= 0) {
            return 0;
        }
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        long xp = XpUtil.liquidToExperience((long)resource.amount);
        long canFillXP = Math.min(xp, xpSpace = this.getMaximumExperience() - this.getExperienceTotal());
        if (canFillXP <= 0L) {
            return 0;
        }
        if (doFill) {
            this.addExperience(canFillXP);
        }
        return MathUtil.limit(XpUtil.experienceToLiquid(canFillXP));
    }

    public boolean canDrain(EnumFacing from, Fluid fluidIn) {
        return fluidIn != null && FluidUtil.areFluidsTheSame((Fluid)fluidIn, (Fluid)((Fluid)XP.get()));
    }

    @Nonnull
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo(new FluidStack((Fluid)XP.get(), this.getFluidAmount()), this.getCapacity())};
    }

    @Deprecated
    public int getCapacity() {
        return MathUtil.limit(this.getCapacityL());
    }

    public long getCapacityL() {
        if (this.maxXp == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return XpUtil.experienceToLiquid(this.maxXp);
    }

    @Deprecated
    public int getFluidAmount() {
        return MathUtil.limit(this.getFluidAmountL());
    }

    public long getFluidAmountL() {
        return XpUtil.experienceToLiquid(this.experienceTotal);
    }

    @Nonnull
    public FluidTank readFromNBT(NBTTagCompound nbtRoot) {
        this.experienceTotal = nbtRoot.func_150297_b("xp", 4) ? nbtRoot.func_74763_f("experienceTotal") : (nbtRoot.func_150297_b("experienceTotal", 3) ? (long)nbtRoot.func_74762_e("experienceTotal") : 0L);
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74772_a("xp", this.experienceTotal);
        nbtRoot.func_74768_a("experienceTotal", this.getExperienceTotalIntLimited());
        return nbtRoot;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.experienceTotal);
    }

    public void fromBytes(ByteBuf buf) {
        this.experienceTotal = buf.readLong();
    }

    @Nonnull
    public FluidStack getFluid() {
        return new FluidStack((Fluid)XP.get(), this.getFluidAmount());
    }

    public FluidTankInfo getInfo() {
        return this.getTankInfo(null)[0];
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.fill(null, resource, doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(null, maxDrain, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.drain(null, resource, doDrain);
    }

    public void setFluid(@Nullable FluidStack fluid) {
        this.experienceTotal = 0L;
        if (fluid != null && fluid.getFluid() != null) {
            if (XP.get() == fluid.getFluid()) {
                this.addExperience(XpUtil.liquidToExperience((long)fluid.amount));
            } else {
                throw new InvalidParameterException(fluid.getFluid() + " is no XP juice");
            }
        }
        this.xpDirty = true;
    }

    public void setCapacity(int capacity) {
        throw new InvalidParameterException();
    }

    protected void onContentsChanged() {
        super.onContentsChanged();
        if (this.tile instanceof ITankAccess) {
            ((ITankAccess)this.tile).setTanksDirty();
        } else if (this.tile != null) {
            this.tile.func_70296_d();
        }
    }

    public boolean canFillFluidType(FluidStack resource) {
        return this.canFill() && resource != null && resource.getFluid() != null && FluidUtil.areFluidsTheSame((Fluid)resource.getFluid(), (Fluid)((Fluid)XP.get()));
    }

    public boolean canDrainFluidType(@Nullable FluidStack resource) {
        return this.canFill() && resource != null && resource.getFluid() != null && FluidUtil.areFluidsTheSame((Fluid)resource.getFluid(), (Fluid)((Fluid)XP.get()));
    }
}

