/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.recipes;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.material.alloy.endergy.AlloyEndergy;
import crazypants.enderio.base.material.glass.FusedQuartzType;
import crazypants.enderio.base.material.material.Material;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

@Mod.EventBusSubscriber(modid="enderio")
public class MaterialOredicts {
    static final String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
    private static final NNList<String> REGISTERED = new NNList();

    public static void init(FMLInterModComms.IMCEvent event) {
        Material.getActiveMaterials().apply((NNList.Callback)new NNList.Callback<Material>(){

            public void apply(@Nonnull Material material) {
                if (material.hasDependency()) {
                    MaterialOredicts.registerOre(material.getOreDict(), material.getStack());
                }
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerOredict(@Nonnull RegistryEvent.Register<Item> event) {
        Material.getActiveMaterials().apply((NNList.Callback)new NNList.Callback<Material>(){

            public void apply(@Nonnull Material material) {
                if (!material.hasDependency()) {
                    // empty if block
                }
            }
        });
        NNList.of(Alloy.class).apply((NNList.Callback)new NNList.Callback<Alloy>(){

            public void apply(@Nonnull Alloy alloy) {
            }
        });
        NNList.of(AlloyEndergy.class).apply((NNList.Callback)new NNList.Callback<AlloyEndergy>(){

            public void apply(@Nonnull AlloyEndergy alloy) {
            }
        });
        for (int i = 0; i < dyes.length; ++i) {
        }
        for (FusedQuartzType fusedQuartzType : FusedQuartzType.values()) {
        }
        MaterialOredicts.registerOre("itemSkull", new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE));
        MaterialOredicts.registerOre("itemSkull", new ItemStack(ModObject.blockEndermanSkull.getBlockNN()));
        MaterialOredicts.registerOre("egg", new ItemStack(ModObject.item_owl_egg.getItemNN()));
        MaterialOredicts.registerOre("eggOwl", new ItemStack(ModObject.item_owl_egg.getItemNN()));
    }

    public static void registerOre(@Nonnull String name, @Nonnull ItemStack ore) {
        OreDictionary.registerOre((String)name, (ItemStack)ore);
        REGISTERED.add((Object)name);
    }

    public static void checkOreRegistrations() {
        NNList failed = new NNList();
        for (String name : REGISTERED) {
            if (!OreDictionary.getOres((String)name).isEmpty()) continue;
            failed.add((Object)name);
        }
        if (!failed.isEmpty()) {
            Log.warn("=========================================================================");
            Log.warn("= Dear other mod author, ================================================");
            Log.warn("= while we do not care what is in those oredict entries, our mod is =====");
            Log.warn("= coded to assume that there is at least one item in them. Feel free to =");
            Log.warn("= put in some invisible unobtainable dummy item, but please don't empty =");
            Log.warn("= them completely. ======================================================");
            Log.warn("= Thank you! ============================================================");
            Log.warn("=========================================================================");
            EnderIO.proxy.stopWithErrorScreen("=======================================================================", "== ENDER IO FATAL ERROR ==", "=======================================================================", "We registered some items with the Ore Dictionary but they are now gone.", "That means that some other mod has messed with our stuff.", "=======================================================================", "This is NOT a bug in Ender IO.", "=======================================================================", "Find out which mod deletes our items and report this to THEM.", "=======================================================================", "Missing registration(s):", String.join((CharSequence)", ", (Iterable<? extends CharSequence>)failed), "=======================================================================", "", "");
        }
    }
}

