/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.item;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.network.NetworkUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.integration.jei.IHaveGhostTargets;
import crazypants.enderio.util.Prep;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public class ModItemFilter
implements IItemFilter.WithGhostSlots {
    @Nonnull
    private static final String NBT_BLACKLIST = "blacklist";
    private final String[] mods = new String[3];
    private boolean blacklist = false;

    public String setMod(int index, @Nonnull ItemStack itemStack) {
        if (index < 0 || index >= this.mods.length) {
            return null;
        }
        if (itemStack.func_190926_b()) {
            this.setMod(index, (String)null);
            return null;
        }
        ResourceLocation ui = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)itemStack.func_77973_b());
        if (ui == null) {
            this.setMod(index, (String)null);
            return null;
        }
        String targetMod = ui.func_110624_b();
        this.setMod(index, targetMod);
        return targetMod;
    }

    public String setMod(int index, @Nonnull FluidStack fluid) {
        if (index < 0 || index >= this.mods.length) {
            return null;
        }
        if (fluid.getFluid() == null) {
            this.setMod(index, (String)null);
            return null;
        }
        String targetMod = FluidRegistry.getModId((FluidStack)fluid);
        this.setMod(index, targetMod);
        return targetMod;
    }

    public String setMod(int index, @Nonnull Enchantment enchantment) {
        if (index < 0 || index >= this.mods.length) {
            return null;
        }
        ResourceLocation ui = (ResourceLocation)Enchantment.field_185264_b.func_177774_c((Object)enchantment);
        if (ui == null) {
            this.setMod(index, (String)null);
            return null;
        }
        String targetMod = ui.func_110624_b();
        this.setMod(index, targetMod);
        return targetMod;
    }

    public void setMod(int index, String mod) {
        if (index < 0 || index >= this.mods.length) {
            return;
        }
        this.mods[index] = mod;
    }

    public String getModAt(int index) {
        if (index < 0 || index >= this.mods.length) {
            return null;
        }
        return this.mods[index];
    }

    public void setBlacklist(boolean value) {
        this.blacklist = value;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    @Override
    public boolean doesItemPassFilter(@Nullable IItemHandler inventory, @Nonnull ItemStack item) {
        if (Prep.isInvalid(item)) {
            return false;
        }
        ResourceLocation ui = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item.func_77973_b());
        if (ui == null) {
            return false;
        }
        String targetMod = ui.func_110624_b();
        for (String mod : this.mods) {
            if (!targetMod.equals(mod)) continue;
            return !this.blacklist;
        }
        return this.blacklist;
    }

    @Override
    public void setInventorySlotContents(int slot, @Nonnull ItemStack stack) {
        this.setMod(slot, stack);
    }

    @Override
    public boolean isSticky() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        for (int i = 0; i < this.mods.length; ++i) {
            String mod = nbtRoot.func_74779_i("mod" + i);
            this.mods[i] = mod.isEmpty() || "-".equals(mod) ? null : mod;
            this.blacklist = nbtRoot.func_74764_b(NBT_BLACKLIST) ? nbtRoot.func_74767_n(NBT_BLACKLIST) : false;
        }
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        for (int i = 0; i < this.mods.length; ++i) {
            String mod = this.mods[i];
            if (mod == null || mod.trim().isEmpty()) {
                nbtRoot.func_74778_a("mod" + i, "-");
                continue;
            }
            nbtRoot.func_74778_a("mod" + i, mod);
        }
        nbtRoot.func_74757_a(NBT_BLACKLIST, this.blacklist);
    }

    @Override
    public void writeToByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound root = new NBTTagCompound();
        this.writeToNBT(root);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)root, (ByteBuf)buf);
    }

    @Override
    public void readFromByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readFromNBT(tag);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public void createGhostSlots(@Nonnull NNList<GhostSlot> slots, int xOffset, int yOffset, @Nullable Runnable cb) {
        int index = 0;
        for (int row = 0; row < this.mods.length; ++row) {
            slots.add((Object)new ModFilterGhostSlot(index, xOffset, yOffset + 22 * row, cb));
            ++index;
        }
    }

    class ModFilterGhostSlot
    extends GhostSlot
    implements IHaveGhostTargets.IFluidGhostSlot,
    IHaveGhostTargets.IEnchantmentGhostSlot {
        private final Runnable cb;
        @Nonnull
        private ItemStack lastItem = Prep.getEmpty();
        private long lastSet = -1L;

        ModFilterGhostSlot(int slot, int x, int y, Runnable cb) {
            this.setX(x);
            this.setY(y);
            this.setSlot(slot);
            this.cb = cb;
        }

        public void putStack(@Nonnull ItemStack stack, int realsize) {
            ModItemFilter.this.setInventorySlotContents(this.getSlot(), stack);
            this.lastItem = stack.func_77946_l();
            this.lastSet = EnderIO.proxy.getTickCount();
            this.cb.run();
        }

        @Nonnull
        public ItemStack getStack() {
            return this.lastItem;
        }

        public float getGrayOutLevel() {
            if (Prep.isValid(this.lastItem)) {
                long age = EnderIO.proxy.getTickCount() - this.lastSet;
                if (age >= 0L && age < 50L) {
                    return (float)age / 50.0f;
                }
                this.lastItem = Prep.getEmpty();
                return 1.0f;
            }
            return super.getGrayOutLevel();
        }

        @Override
        public void putFluidStack(@Nonnull FluidStack fluidStack) {
            ModItemFilter.this.setMod(this.getSlot(), fluidStack);
            this.lastItem = Prep.getEmpty();
            this.cb.run();
        }

        @Override
        public void putFluid(@Nonnull Fluid fluid) {
            ModItemFilter.this.setMod(this.getSlot(), new FluidStack(fluid, 0));
            this.lastItem = Prep.getEmpty();
            this.cb.run();
        }

        @Override
        public void putEnchantment(@Nonnull Enchantment enchantment) {
            ModItemFilter.this.setMod(this.getSlot(), enchantment);
            this.lastItem = Prep.getEmpty();
            this.cb.run();
        }
    }
}

