/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.button;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.render.EnderWidget;
import javax.annotation.Nonnull;

public class MultiIconButton
extends IconButton {
    @Nonnull
    private final IWidgetIcon unpressed;
    @Nonnull
    private final IWidgetIcon pressed;
    @Nonnull
    private final IWidgetIcon hover;

    public MultiIconButton(@Nonnull IGuiScreen gui, int id, int x, int y, @Nonnull IWidgetIcon unpressed, @Nonnull IWidgetIcon pressed, @Nonnull IWidgetIcon hover) {
        super(gui, id, x, y, null);
        this.unpressed = unpressed;
        this.pressed = pressed;
        this.hover = hover;
        this.setSize(unpressed.getWidth(), unpressed.getHeight());
    }

    @Override
    @Nonnull
    protected IWidgetIcon getIconForHoverState(int hoverState) {
        if (hoverState == 0) {
            return this.pressed;
        }
        if (hoverState == 2) {
            return this.hover;
        }
        return this.unpressed;
    }

    @Nonnull
    public static MultiIconButton createRightArrowButton(@Nonnull IGuiScreen gui, int id, int x, int y) {
        return new MultiIconButton(gui, id, x, y, EnderWidget.RIGHT_ARROW, EnderWidget.RIGHT_ARROW_PRESSED, EnderWidget.RIGHT_ARROW_HOVER);
    }

    @Nonnull
    public static MultiIconButton createLeftArrowButton(@Nonnull IGuiScreen gui, int id, int x, int y) {
        return new MultiIconButton(gui, id, x, y, EnderWidget.LEFT_ARROW, EnderWidget.LEFT_ARROW_PRESSED, EnderWidget.LEFT_ARROW_HOVER);
    }

    @Nonnull
    public static MultiIconButton createAddButton(@Nonnull IGuiScreen gui, int id, int x, int y) {
        return new MultiIconButton(gui, id, x, y, EnderWidget.ADD_BUT, EnderWidget.ADD_BUT_PRESSED, EnderWidget.ADD_BUT_HOVER);
    }

    @Nonnull
    public static MultiIconButton createMinusButton(@Nonnull IGuiScreen gui, int id, int x, int y) {
        return new MultiIconButton(gui, id, x, y, EnderWidget.MINUS_BUT, EnderWidget.MINUS_BUT_PRESSED, EnderWidget.MINUS_BUT_HOVER);
    }
}

