/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import elec332.core.util.ItemStackHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryHelper {
    @SideOnly(value=Side.CLIENT)
    public static List<String> getTooltip(ItemStack stack, @Nullable EntityPlayer playerIn, boolean advanced) {
        return stack.func_82840_a(playerIn, (ITooltipFlag)(advanced ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
    }

    @SideOnly(value=Side.CLIENT)
    public static void addInformation(Item item, ItemStack stack, World world, List<String> tooltip, boolean advanced) {
        item.func_77624_a(stack, world, tooltip, (ITooltipFlag)(advanced ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
    }

    public static void readItemsFromNBT(@Nonnull NBTTagCompound data, @Nonnull List<ItemStack> items) {
        items.clear();
        NBTTagList nbttaglist = data.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= items.size()) continue;
            items.set(j, ItemStackHelper.loadItemStackFromNBT(nbttagcompound));
        }
    }

    public static NBTTagCompound writeItemsToNBT(@Nonnull List<ItemStack> items) {
        return InventoryHelper.writeItemsToNBT(new NBTTagCompound(), items);
    }

    public static NBTTagCompound writeItemsToNBT(@Nonnull NBTTagCompound tag, @Nonnull List<ItemStack> items) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack itemstack = items.get(i);
            if (!ItemStackHelper.isStackValid(itemstack)) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        tag.func_74782_a("Items", (NBTBase)nbttaglist);
        return tag;
    }

    @Nonnull
    @Deprecated
    public static ItemStack copyItemStack(@Nullable ItemStack stack) {
        return ItemStackHelper.copyItemStack(stack);
    }

    public static boolean addItemToInventory(IItemHandler inventory, ItemStack itemstack, boolean simulate) {
        int invSize = InventoryHelper.getMainInventorySize(inventory);
        return InventoryHelper.addItemToInventory(inventory, itemstack, 0, invSize, simulate);
    }

    public static int getMainInventorySize(IItemHandler inv) {
        return inv.getSlots();
    }

    public static boolean addItemToInventory(IItemHandler inventory, ItemStack itemstack, int start, int end, boolean simulate) {
        return !ItemStackHelper.isStackValid(ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)itemstack, (boolean)simulate));
    }

    public static boolean areNBTsEqual(ItemStack first, ItemStack second) {
        return ItemStack.func_77970_a((ItemStack)first, (ItemStack)second);
    }

    public static boolean areEqualNoSizeNoNBT(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return first == second;
        }
        if (first.func_77973_b() != second.func_77973_b()) {
            return false;
        }
        return !first.func_77981_g() || first.func_77952_i() == second.func_77952_i();
    }

    public static boolean areEqualNoSize(ItemStack first, ItemStack second) {
        return InventoryHelper.areEqualNoSizeNoNBT(first, second) && InventoryHelper.areNBTsEqual(first, second);
    }

    public static int getEmptySlot(IItemHandler inventory, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (ItemStackHelper.isStackValid(inventory.getStackInSlot(i))) continue;
            return i;
        }
        return -1;
    }

    public static void setContents(IItemHandlerModifiable inventory, List<ItemStack> list) {
        if (inventory.getSlots() != list.size()) {
            System.out.println("Error copying inventory contents!");
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            inventory.setStackInSlot(i, ItemStackHelper.copyItemStack(list.get(i)));
        }
    }

    public static List<ItemStack> storeContents(IItemHandler inventory) {
        ArrayList<ItemStack> copy = new ArrayList<ItemStack>(inventory.getSlots());
        for (int i = 0; i < inventory.getSlots(); ++i) {
            copy.add(i, ItemStackHelper.copyItemStack(inventory.getStackInSlot(i)));
        }
        return copy;
    }

    public static int amountOfOreDictItemsInventoryHas(IItemHandler inventory, String s, int i) {
        int total = 0;
        if (InventoryHelper.doesInventoryHaveOreDictItem(inventory, s)) {
            for (ItemStack oreStack : OreDictionary.getOres((String)s)) {
                for (int p = 0; p < InventoryHelper.amountOfItemsInventoryHas(inventory, oreStack); ++p) {
                    ++total;
                }
            }
        }
        return total;
    }

    public static boolean doesInventoryHaveOreDictItem(IItemHandler inventory, String s) {
        for (ItemStack stack : OreDictionary.getOres((String)s)) {
            if (InventoryHelper.getFirstSlotWithItemStackNoNBT(inventory, stack) == -1) continue;
            return true;
        }
        return false;
    }

    public static int amountOfItemsInventoryHas(IItemHandler inventory, ItemStack stack) {
        int total = 0;
        if (InventoryHelper.getFirstSlotWithItemStackNoNBT(inventory, stack) != -1) {
            Integer[] integerArray = InventoryHelper.getSlotsWithItemStackNoNBT(inventory, stack);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int q = integerArray[i];
                ItemStack inSlot = inventory.getStackInSlot(q);
                for (int p = 0; p < inSlot.func_190916_E(); ++p) {
                    ++total;
                }
            }
        }
        return total;
    }

    public static Integer[] getSlotsWithItemStackNoNBT(IItemHandler inventory, ItemStack stack) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stackInSlot = inventory.getStackInSlot(i);
            if (!ItemStackHelper.isStackValid(stackInSlot) || stack == null || stackInSlot.func_77973_b() != stack.func_77973_b()) continue;
            if (stackInSlot.func_77952_i() == stack.func_77952_i() || stack.func_77952_i() == Short.MAX_VALUE) {
                ret.add(i);
            }
            if (stackInSlot.func_77973_b().func_77614_k() || stack.func_77973_b().func_77614_k()) continue;
            ret.add(i);
        }
        if (!ret.isEmpty()) {
            return ret.toArray(new Integer[ret.size()]);
        }
        return null;
    }

    public static int getFirstSlotWithItemStackNoNBT(IItemHandler inventory, ItemStack stack) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stackInSlot = inventory.getStackInSlot(i);
            if (!ItemStackHelper.isStackValid(stackInSlot) || stack == null || stackInSlot.func_77973_b() != stack.func_77973_b()) continue;
            if (stackInSlot.func_77952_i() == stack.func_77952_i() || stack.func_77952_i() == Short.MAX_VALUE) {
                return i;
            }
            if (stackInSlot.func_77973_b().func_77614_k() || stack.func_77973_b().func_77614_k()) continue;
            return i;
        }
        return -1;
    }
}

