/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import elec332.core.ElecCore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;

public class IOHelper {
    public static final IObjectIO<NBTTagCompound> NBT_IO = new IObjectIO<NBTTagCompound>(){

        @Override
        public void write(File file, NBTTagCompound obj) throws IOException {
            CompressedStreamTools.func_74795_b((NBTTagCompound)obj, (File)file);
        }

        @Override
        public NBTTagCompound read(File file) throws IOException {
            return CompressedStreamTools.func_74797_a((File)file);
        }

        @Override
        public NBTTagCompound returnOnReadFail() {
            return new NBTTagCompound();
        }
    };
    public static final IObjectIO<NBTTagCompound> NBT_COMPRESSED_IO = new IObjectIO<NBTTagCompound>(){

        @Override
        public void write(File file, NBTTagCompound obj) throws IOException {
            CompressedStreamTools.func_74799_a((NBTTagCompound)obj, (OutputStream)new FileOutputStream(file));
        }

        @Override
        public NBTTagCompound read(File file) throws IOException {
            return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        }

        @Override
        public NBTTagCompound returnOnReadFail() {
            return new NBTTagCompound();
        }
    };

    @Nonnull
    public static InputStream getFromResource(@Nonnull ResourceLocation resourceLocation) throws IOException {
        String location = "/assets/" + resourceLocation.func_110624_b() + "/" + resourceLocation.func_110623_a();
        InputStream ret = ElecCore.class.getResourceAsStream(location);
        if (ret != null) {
            return ret;
        }
        throw new FileNotFoundException(location);
    }

    public static void createFile(@Nonnull File file) throws IOException {
        if (!(file.exists() || file.getParentFile().mkdirs() || file.createNewFile())) {
            throw new IOException();
        }
    }

    public static void ensureExists(File folder) {
        if (!folder.exists() && !folder.mkdir()) {
            throw new RuntimeException();
        }
    }

    public static void deleteIfExists(File file) {
        if (file.exists() && !file.delete()) {
            throw new RuntimeException();
        }
    }

    public static <T> T readWithPossibleBackup(@Nonnull File file, @Nonnull IObjectIO<T> io) {
        File backup = null;
        boolean b = false;
        try {
            backup = IOHelper.getBackupFile(file);
            if (!file.exists()) {
                if (!backup.exists()) {
                    return io.returnOnReadFail();
                }
                b = true;
                return io.read(backup);
            }
            return io.read(file);
        }
        catch (IOException e) {
            try {
                ElecCore.logger.error("Error reading file, something weird must have happened when you last shutdown MC, unfortunately, some game data will probably be lost. Fixing file now....");
                String date = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
                file = b ? backup : file;
                File newFile = new File(file.getCanonicalPath() + "_errored_" + date);
                FileUtils.moveFile((File)file, (File)newFile);
                IOHelper.deleteIfExists(file);
                if (b) {
                    return io.returnOnReadFail();
                }
                return io.read(backup);
            }
            catch (IOException ex) {
                ElecCore.logger.info("Failed to read backup file: " + file);
                return io.returnOnReadFail();
            }
        }
    }

    public static <T> void writeWithBackup(@Nonnull File file, @Nonnull T obj, @Nonnull IObjectIO<T> io) {
        File fileNew;
        File fileBack;
        try {
            fileBack = IOHelper.getBackupFile(file);
            fileNew = new File(file.getCanonicalPath() + "_new");
            io.write(fileNew, obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (file.exists()) {
            IOHelper.deleteIfExists(fileBack);
            file.renameTo(fileBack);
        }
        IOHelper.deleteIfExists(file);
        fileNew.renameTo(file);
        IOHelper.deleteIfExists(fileNew);
    }

    public static File getBackupFile(@Nonnull File file) throws IOException {
        return new File(file.getCanonicalPath() + "_back");
    }

    public static interface IObjectIO<T> {
        default public void write(File file, T obj) throws IOException {
            throw new UnsupportedOperationException();
        }

        default public T read(File file) throws IOException {
            throw new UnsupportedOperationException();
        }

        default public T returnOnReadFail() {
            throw new RuntimeException();
        }
    }
}

