/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.utility;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.dave.compactmachines3.world.tools.DimensionTools;

public class DimensionBlockPos {
    private final BlockPos pos;
    private final int dimension;

    public DimensionBlockPos(BlockPos pos, int dimension) {
        this.pos = pos;
        this.dimension = dimension;
    }

    public DimensionBlockPos(NBTTagCompound tag) {
        this.pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
        this.dimension = tag.func_74762_e("dim");
    }

    public DimensionBlockPos(ByteBuf buffer) {
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        this.pos = new BlockPos(x, y, z);
        this.dimension = buffer.readInt();
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public int getDimension() {
        return this.dimension;
    }

    public TileEntity getTileEntity() {
        WorldServer world = DimensionTools.getWorldServerForDimension(this.dimension);
        return world.func_175625_s(this.pos);
    }

    public NBTTagCompound getAsNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("x", this.pos.func_177958_n());
        tag.func_74768_a("y", this.pos.func_177956_o());
        tag.func_74768_a("z", this.pos.func_177952_p());
        tag.func_74768_a("dim", this.dimension);
        return tag;
    }

    public void writeToByteBuf(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.dimension);
    }
}

