/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.gui.psd;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import org.dave.compactmachines3.gui.psd.Page;
import org.dave.compactmachines3.gui.psd.SimpleTextPage;
import org.dave.compactmachines3.gui.psd.segments.ChaptersSegment;
import org.dave.compactmachines3.gui.psd.segments.ImageSegment;
import org.dave.compactmachines3.gui.psd.segments.TextSegment;
import org.dave.compactmachines3.gui.psd.segments.VerticalSpaceSegment;
import org.dave.compactmachines3.init.Blockss;

public class Pages {
    private final Map<String, Page> pages = new HashMap<String, Page>();
    private String activePage = "welcome";

    public Pages() {
        Page welcomePage = new Page(this, "welcome");
        welcomePage.addSegment(new TextSegment("welcome"));
        welcomePage.addSegment(new VerticalSpaceSegment(11));
        welcomePage.addSegment(new TextSegment("chapters"));
        ChaptersSegment chapters = new ChaptersSegment(this);
        chapters.addChapter(new ItemStack((Block)Blockss.machine, 1), "machines");
        chapters.addChapter(new ItemStack((Block)Blockss.tunnel, 1), "tunnels");
        chapters.addChapter(new ItemStack((Block)Blockss.redstoneTunnel, 1), "redstone_tunnels");
        chapters.addChapter(new ItemStack((Block)Blockss.fieldProjector, 1), "crafting");
        welcomePage.addSegment(chapters);
        this.registerPage(welcomePage);
        this.registerPage(new SimpleTextPage(this, "tunnels"));
        this.registerPage(new SimpleTextPage(this, "machines"));
        this.registerPage(new SimpleTextPage(this, "redstone_tunnels"));
        Page craftingPage = new Page(this, "crafting");
        craftingPage.addSegment(new TextSegment("text"));
        craftingPage.addSegment(new VerticalSpaceSegment(-4));
        ImageSegment craftingExampleImage = new ImageSegment("compactmachines3:textures/gui/field_example.png", 50, 50);
        craftingExampleImage.setTextureWidth(256);
        craftingExampleImage.setTextureHeight(256);
        craftingExampleImage.setCentered(true);
        craftingPage.addSegment(craftingExampleImage);
        this.registerPage(craftingPage);
    }

    public void registerPage(Page page) {
        this.pages.put(page.getName(), page);
    }

    public Page getActivePage() {
        return this.pages.get(this.activePage);
    }

    public void setActivePage(Page page) {
        this.activePage = page.getName();
    }

    public void setActivePage(String page) {
        if (this.pages.containsKey(page)) {
            this.activePage = page;
        }
    }

    public Set<Page> getPages() {
        return new HashSet<Page>(this.pages.values());
    }
}

