/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.gui.framework.widgets;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import org.dave.compactmachines3.gui.framework.SmartNumberFormatter;
import org.dave.compactmachines3.gui.framework.widgets.WidgetWithValue;

public class WidgetProgressBar
extends WidgetWithValue<Double> {
    int borderColor = -16777216;
    int foregroundColor = -13391309;
    int backgroundColor = -13421773;
    int textColor = -1;
    double rangeMin = 0.0;
    double rangeMax = 100.0;
    EnumDisplayMode displayMode = EnumDisplayMode.PERCENTAGE;

    public WidgetProgressBar() {
        this.value = 0.0;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public WidgetProgressBar setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public WidgetProgressBar setForegroundColor(int foregroundColor) {
        this.foregroundColor = foregroundColor;
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public WidgetProgressBar setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public WidgetProgressBar setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    public double getRangeMin() {
        return this.rangeMin;
    }

    public WidgetProgressBar setRangeMin(double rangeMin) {
        this.rangeMin = rangeMin;
        return this;
    }

    public double getRangeMax() {
        return this.rangeMax;
    }

    public WidgetProgressBar setRangeMax(double rangeMax) {
        this.rangeMax = rangeMax;
        return this;
    }

    public EnumDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public WidgetProgressBar setDisplayMode(EnumDisplayMode displayMode) {
        this.displayMode = displayMode;
        return this;
    }

    @Override
    public void draw(GuiScreen screen) {
        int x = 0;
        int y = 0;
        int width = this.width;
        int height = this.height;
        Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)this.borderColor);
        Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)this.backgroundColor);
        double progress = ((Double)this.getValue() - this.getRangeMin()) / (this.getRangeMax() - this.getRangeMin());
        progress = Math.min(Math.max(progress, 0.0), 1.0);
        int progressWidth = (int)(Math.ceil((double)width - 2.0) * progress);
        Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + 1 + progressWidth), (int)(y + height - 1), (int)this.foregroundColor);
        if (this.displayMode != EnumDisplayMode.NOTHING && this.displayMode != EnumDisplayMode.CUSTOM) {
            FontRenderer fr = screen.field_146297_k.field_71466_p;
            String content = "";
            if (this.displayMode == EnumDisplayMode.PERCENTAGE) {
                content = String.format("%.1f%%", progress * 100.0);
            } else if (this.displayMode == EnumDisplayMode.VALUE) {
                content = String.valueOf(SmartNumberFormatter.formatNumber((Double)this.getValue()));
            } else if (this.displayMode == EnumDisplayMode.VALUE_AND_PERCENTAGE) {
                content = String.format("%.1f%% (%s)", progress * 100.0, SmartNumberFormatter.formatNumber((Double)this.getValue()));
            }
            int xPos = x + 1 + (width - fr.func_78256_a(content)) / 2;
            fr.func_78276_b(content, xPos, y + 2, this.textColor);
        }
    }

    public static enum EnumDisplayMode {
        NOTHING,
        VALUE,
        PERCENTAGE,
        VALUE_AND_PERCENTAGE,
        CUSTOM;

    }
}

