/*
 * Decompiled with CFR 0.152.
 */
package c4.colytra.asm;

import c4.colytra.asm.ColytraLoadingPlugin;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class ElytraTransformer
implements IClassTransformer {
    public static final ClassnameMap CLASS_MAPPINGS = new ClassnameMap("net/minecraft/entity/EntityLivingBase", "vn", "net/minecraft/client/entity/EntityPlayerSP", "bub", "net/minecraft/inventory/EntityEquipmentSlot", "vl", "net/minecraft/item/ItemStack", "aip");
    private static final Map<String, Transformer> transformers = new HashMap<String, Transformer>();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformers.containsKey(transformedName)) {
            return (byte[])transformers.get(transformedName).apply(basicClass);
        }
        return basicClass;
    }

    private static byte[] transformElytraUpdate(byte[] basicClass) {
        ElytraTransformer.log("Preparing to transform EntityLivingBase");
        MethodSignature sig = new MethodSignature("onLivingUpdate", "func_70636_d", "n", "()V");
        byte[] transClass = ElytraTransformer.transform(basicClass, Pair.of((Object)sig, (Object)ElytraTransformer.combine(node -> node.getOpcode() == 183, (method, node) -> {
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "c4/colytra/asm/ASMHooks", "updateColytra", "(Lnet/minecraft/entity/EntityLivingBase;)V"));
            method.instructions.insert(node, toInject);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformClientElytraUpdate(byte[] basicClass) {
        ElytraTransformer.log("Preparing to transform EntityPlayerSP");
        MethodSignature sig = new MethodSignature("onLivingUpdate", "func_70636_d", "n", "()V");
        byte[] transClass = ElytraTransformer.transform(basicClass, Pair.of((Object)sig, (Object)ElytraTransformer.combine(node -> node.getOpcode() == 182 && ElytraTransformer.checkDesc(((MethodInsnNode)node).desc, "(Lnet/minecraft/inventory/EntityEquipmentSlot;)Lnet/minecraft/item/ItemStack;"), (method, node) -> {
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "c4/colytra/asm/ASMHooks", "updateClientColytra", "(Lnet/minecraft/entity/EntityLivingBase;)V"));
            method.instructions.insert(node, toInject);
            return true;
        })));
        return transClass;
    }

    private static byte[] transform(byte[] basicClass, Pair<MethodSignature, MethodAction> ... methods) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        boolean didAnything = false;
        for (Pair<MethodSignature, MethodAction> pair : methods) {
            ElytraTransformer.log("Initiating transformation to method (" + pair.getLeft() + ")");
            didAnything |= ElytraTransformer.findMethodAndTransform(node, (MethodSignature)pair.getLeft(), (MethodAction)pair.getRight());
        }
        if (didAnything) {
            ClassWriter writer = new ClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    private static boolean findMethodAndTransform(ClassNode node, MethodSignature sig, MethodAction action) {
        String funcName = sig.funcName;
        if (ColytraLoadingPlugin.runtimeDeobf) {
            funcName = sig.srgName;
        }
        for (MethodNode method : node.methods) {
            if (!method.name.equals(funcName) && !method.name.equals(sig.obfName) && !method.name.equals(sig.srgName) || !method.desc.equals(sig.funcDesc) && !method.desc.equals(sig.obfDesc)) continue;
            ElytraTransformer.log("Found method, initiating patch...");
            boolean finish = action.test(method);
            ElytraTransformer.log("Patch result: " + (finish ? "Success!" : "Failure"));
            return finish;
        }
        ElytraTransformer.log("Failed to find method!");
        return false;
    }

    private static MethodAction combine(NodeFilter filter, NodeAction action) {
        return mnode -> ElytraTransformer.applyOnNode(mnode, filter, action);
    }

    private static boolean applyOnNode(MethodNode method, NodeFilter filter, NodeAction action) {
        ListIterator itr = method.instructions.iterator();
        boolean didAnything = false;
        while (itr.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)itr.next();
            if (!filter.test(node)) continue;
            ElytraTransformer.log("Found target node for patching: " + ElytraTransformer.getNodeString(node));
            didAnything = true;
            if (!action.test(method, node)) continue;
            break;
        }
        return didAnything;
    }

    private static String getNodeString(AbstractInsnNode node) {
        Textifier print = new Textifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)print);
        node.accept((MethodVisitor)visitor);
        StringWriter sw = new StringWriter();
        print.print(new PrintWriter(sw));
        print.getText().clear();
        return sw.toString().replaceAll("\n", "").trim();
    }

    private static boolean checkDesc(String desc, String expected) {
        return desc.equals(expected) || desc.equals(MethodSignature.obfuscate(expected));
    }

    private static void log(String str) {
        FMLLog.info((String)"[Colytra ASM] %s", (Object[])new Object[]{str});
    }

    static {
        transformers.put("net.minecraft.entity.EntityLivingBase", ElytraTransformer::transformElytraUpdate);
        transformers.put("net.minecraft.client.entity.EntityPlayerSP", ElytraTransformer::transformClientElytraUpdate);
    }

    private static interface NodeAction
    extends BiPredicate<MethodNode, AbstractInsnNode> {
    }

    private static interface NodeFilter
    extends Predicate<AbstractInsnNode> {
    }

    private static interface MethodAction
    extends Predicate<MethodNode> {
    }

    private static interface Transformer
    extends Function<byte[], byte[]> {
    }

    private static class MethodSignature {
        String funcName;
        String srgName;
        String obfName;
        String funcDesc;
        String obfDesc;

        MethodSignature(String funcName, String srgName, String obfName, String funcDesc) {
            this.funcName = funcName;
            this.srgName = srgName;
            this.obfName = obfName;
            this.funcDesc = funcDesc;
            this.obfDesc = MethodSignature.obfuscate(funcDesc);
        }

        public String toString() {
            return "Names [" + this.funcName + ", " + this.srgName + ", " + this.obfName + "] Descriptor " + this.funcDesc + " / " + this.obfDesc;
        }

        private static String obfuscate(String desc) {
            for (String s : CLASS_MAPPINGS.keySet()) {
                if (!desc.contains(s)) continue;
                desc = desc.replaceAll(s, (String)CLASS_MAPPINGS.get(s));
            }
            return desc;
        }
    }

    public static class ClassnameMap
    extends HashMap<String, String> {
        ClassnameMap(String ... s) {
            for (int i = 0; i < s.length / 2; ++i) {
                this.put(s[i * 2], s[i * 2 + 1]);
            }
        }

        @Override
        public String put(String key, String value) {
            return super.put("L" + key + ";", "L" + value + ";");
        }
    }
}

