/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.item.map;

import codechicken.lib.render.item.map.IMapRenderer;
import java.util.IdentityHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MapRenderRegistry {
    private static IdentityHashMap<Item, IMapRenderer> mapRenderers = new IdentityHashMap();

    public static boolean shouldHandle(ItemStack stack, boolean inFrame) {
        IMapRenderer mapRenderer = mapRenderers.get(stack.func_77973_b());
        if (mapRenderer != null) {
            return mapRenderer.shouldHandle(stack, inFrame);
        }
        return false;
    }

    public static void handleRender(ItemStack stack, boolean inFrame) {
        IMapRenderer mapRenderer = mapRenderers.get(stack.func_77973_b());
        if (mapRenderer != null) {
            mapRenderer.renderMap(stack, inFrame);
        }
    }

    public static void registerMapRenderer(Item item, IMapRenderer mapRenderer) {
        mapRenderers.put(item, mapRenderer);
    }

    @SubscribeEvent
    public void onItemFrameRender(RenderItemInFrameEvent event) {
        if (MapRenderRegistry.shouldHandle(event.getItem(), true)) {
            event.setCanceled(true);
            MapRenderRegistry.handleRender(event.getItem(), true);
        }
    }

    @SubscribeEvent
    public void renderFirstPersonHand(RenderSpecificHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (!MapRenderRegistry.shouldHandle(stack, false)) {
            return;
        }
        event.setCanceled(true);
        Minecraft minecraft = Minecraft.func_71410_x();
        ItemRenderer itemRenderer = minecraft.func_175597_ag();
        EntityPlayerSP player = minecraft.field_71439_g;
        EnumHand hand = event.getHand();
        float partialTicks = event.getPartialTicks();
        float interpPitch = event.getInterpolatedPitch();
        float swingProgress = event.getSwingProgress();
        float equipProgress = event.getEquipProgress();
        boolean flag = hand == EnumHand.MAIN_HAND;
        EnumHandSide handSide = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        GlStateManager.func_179094_E();
        if (flag && minecraft.func_175597_ag().field_187468_e.func_190926_b()) {
            float f = MathHelper.func_76129_c((float)swingProgress);
            float f1 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
            float f2 = -0.4f * MathHelper.func_76126_a((float)(f * (float)Math.PI));
            GlStateManager.func_179109_b((float)0.0f, (float)(-f1 / 2.0f), (float)f2);
            float f3 = itemRenderer.func_178100_c(interpPitch);
            GlStateManager.func_179109_b((float)0.0f, (float)(0.04f + equipProgress * -1.2f + f3 * -0.5f), (float)-0.72f);
            GlStateManager.func_179114_b((float)(f3 * -85.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            itemRenderer.func_187466_c();
            float f4 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
            GlStateManager.func_179114_b((float)(f4 * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            MapRenderRegistry.handleRender(stack, false);
        } else {
            float f = handSide == EnumHandSide.RIGHT ? 1.0f : -1.0f;
            GlStateManager.func_179109_b((float)(f * 0.125f), (float)-0.125f, (float)0.0f);
            if (!player.func_82150_aj()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(f * 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                itemRenderer.func_187456_a(equipProgress, swingProgress, handSide);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(f * 0.51f), (float)(-0.08f + equipProgress * -1.2f), (float)-0.75f);
            float f1 = MathHelper.func_76129_c((float)swingProgress);
            float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
            float f3 = -0.5f * f2;
            float f4 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
            float f5 = -0.3f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
            GlStateManager.func_179109_b((float)(f * f3), (float)(f4 - 0.3f * f2), (float)f5);
            GlStateManager.func_179114_b((float)(f2 * -45.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(f * f2 * -30.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            MapRenderRegistry.handleRender(stack, false);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }
}

