/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper.profiling.profilers.textures;

import net.darkhax.bookshelf.lib.TableBuilder;
import org.apache.commons.io.FileUtils;

public class TextureMapInfo
implements Comparable<TextureMapInfo> {
    private final String domain;
    private long textureCount = 0L;
    private long pixelCount = 0L;

    public TextureMapInfo(String domain) {
        this.domain = domain;
    }

    public static TableBuilder<TextureMapInfo> createDataTable() {
        TableBuilder builder = new TableBuilder();
        builder.addColumn("Mod ID", TextureMapInfo::getDomain);
        builder.addColumn("Textures", TextureMapInfo::getTextureCount);
        builder.addColumn("Pixels", TextureMapInfo::getPixelCount);
        builder.addColumn("Est. Size", TextureMapInfo::getFileSize);
        return builder;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getTextureCount() {
        return this.textureCount;
    }

    public void addTextureCount(long count) {
        this.textureCount += count;
    }

    public long getPixelCount() {
        return this.pixelCount;
    }

    public void addPixels(long pixels) {
        this.pixelCount += pixels;
    }

    public String getFileSize() {
        long bytes = this.pixelCount * 4L;
        return FileUtils.byteCountToDisplaySize((long)bytes);
    }

    @Override
    public int compareTo(TextureMapInfo o) {
        return Long.compare(this.getPixelCount(), o.getPixelCount());
    }

    public boolean equals(Object o) {
        return o instanceof TextureMapInfo && this.getDomain().equals(((TextureMapInfo)o).getDomain());
    }
}

