/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper.profiling.profilers.textures;

import net.darkhax.bookshelf.lib.TableBuilder;
import org.apache.commons.io.FileUtils;

public class LargeTextureInfo
implements Comparable<LargeTextureInfo> {
    private final String name;
    private final long width;
    private final long height;
    private final long pixels;

    public LargeTextureInfo(String name, long width, long height) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.pixels = height * width;
    }

    public static TableBuilder<LargeTextureInfo> createDataTable() {
        TableBuilder builder = new TableBuilder();
        builder.addColumn("Texture Name", LargeTextureInfo::getName);
        builder.addColumn("Dimensions", e -> e.getWidth() + " X " + e.getHeight());
        builder.addColumn("Pixels", LargeTextureInfo::getPixels);
        builder.addColumn("Est. Size", LargeTextureInfo::getFileSize);
        return builder;
    }

    public String getName() {
        return this.name;
    }

    public long getWidth() {
        return this.width;
    }

    public long getHeight() {
        return this.height;
    }

    public long getPixels() {
        return this.pixels;
    }

    public String getFileSize() {
        return FileUtils.byteCountToDisplaySize((long)(this.pixels * 4L));
    }

    @Override
    public int compareTo(LargeTextureInfo o) {
        return Long.compare(this.getPixels(), o.getPixels());
    }

    public boolean equals(Object o) {
        return o instanceof LargeTextureInfo && this.getName().equals(((LargeTextureInfo)o).getName());
    }
}

