/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper.profiling.profilers.events;

import net.darkhax.bookshelf.lib.TableBuilder;
import net.darkhax.caliper.Caliper;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.ASMEventHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EventInfo {
    private String event = "unknown";
    private String owner = "unknown";
    private String source = "unknown";
    private String location = "unknown";
    private String method = "unknown";
    private String priority = "unknown";
    private String recievedCanceled = "unknown";
    private final boolean isModEvent = true;

    public EventInfo(ASMEventHandler event) {
        try {
            String[] info = event.toString().split(" ");
            if ("ASM:".equalsIgnoreCase(info[0])) {
                String locationInfo;
                String string = info.length == 3 ? info[1] : (locationInfo = info.length == 4 ? info[2] : "unknown");
                String eventInfo = info.length == 3 ? info[2] : (info.length == 4 ? info[3] : "unknown");
                this.location = locationInfo.contains("@") ? locationInfo.substring(0, locationInfo.lastIndexOf(64)) : locationInfo;
                this.event = eventInfo.substring(eventInfo.lastIndexOf(47) + 1, eventInfo.length() - 3);
                if (eventInfo.indexOf(40) <= 0) {
                    Caliper.LOG.warn("Unable to parse event listener: {}.", new Object[]{event.toString()});
                    return;
                }
                this.method = eventInfo.substring(0, eventInfo.indexOf(40));
                SubscribeEvent subInfo = (SubscribeEvent)ReflectionHelper.getPrivateValue(ASMEventHandler.class, (Object)event, (String[])new String[]{"subInfo"});
                if (subInfo != null) {
                    this.priority = subInfo.priority().name().toLowerCase();
                    this.recievedCanceled = Boolean.toString(subInfo.receiveCanceled());
                }
                ModContainer ownerInfo = (ModContainer)ReflectionHelper.getPrivateValue(ASMEventHandler.class, (Object)event, (String[])new String[]{"owner"});
                if (this.owner != null) {
                    this.owner = ownerInfo.getName();
                    this.source = ownerInfo.getSource() != null ? ownerInfo.getSource().getName() : "unknown";
                }
            } else {
                Caliper.LOG.warn("Unable to parse event listener: {}.", new Object[]{event.toString()});
            }
        }
        catch (Exception e) {
            Caliper.LOG.error("Unable to parse event listener: {}.", new Object[]{event.toString()});
            Caliper.LOG.catching((Throwable)e);
        }
    }

    public static TableBuilder<EventInfo> createTable() {
        TableBuilder table = new TableBuilder();
        table.addColumn("Owner", info -> info.owner);
        table.addColumn("Method", info -> info.method);
        table.addColumn("Location", info -> info.location);
        table.addColumn("Priority", info -> info.priority);
        table.addColumn("Source", info -> info.source);
        table.addColumn("RecieveCanceled", info -> info.recievedCanceled);
        return table;
    }

    public String getEvent() {
        return this.event;
    }

    public boolean isValid() {
        return this.isModEvent;
    }
}

