/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.client.hud;

import WayofTime.bloodmagic.client.hud.ElementInfo;
import WayofTime.bloodmagic.client.hud.element.HUDElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.vecmath.Vector2f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="bloodmagic", value={Side.CLIENT})
public class ElementRegistry {
    private static final File CONFIG = new File(Loader.instance().getConfigDir(), "bloodmagic/hud_elements.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<ResourceLocation, HUDElement> HUD_ELEMENTS = Maps.newLinkedHashMap();
    private static final Map<HUDElement, ResourceLocation> REVERSE = Maps.newHashMap();
    private static final Map<ResourceLocation, ElementInfo> ELEMENT_INFO = Maps.newHashMap();

    public static void registerHandler(ResourceLocation key, HUDElement element, Vector2f defaultPosition) {
        HUD_ELEMENTS.put(key, element);
        REVERSE.put(element, key);
        ELEMENT_INFO.put(key, new ElementInfo(defaultPosition, ElementRegistry.getRandomColor()));
    }

    public static void resetPos() {
        ELEMENT_INFO.values().forEach(ElementInfo::resetPosition);
    }

    public static List<HUDElement> getElements() {
        return ImmutableList.copyOf(HUD_ELEMENTS.values());
    }

    public static ResourceLocation getKey(HUDElement element) {
        return REVERSE.get(element);
    }

    public static int getColor(ResourceLocation element) {
        return ELEMENT_INFO.getOrDefault(element, ElementInfo.DUMMY).getBoxColor();
    }

    public static Vector2f getPosition(ResourceLocation element) {
        return ELEMENT_INFO.get(element).getPosition();
    }

    public static void setPosition(ResourceLocation element, Vector2f point) {
        ELEMENT_INFO.compute(element, (resourceLocation, elementInfo) -> {
            if (elementInfo == null) {
                return new ElementInfo(point, ElementRegistry.getRandomColor());
            }
            elementInfo.setPosition(point);
            return elementInfo;
        });
    }

    public static void save(Map<ResourceLocation, Vector2f> newLocations) {
        newLocations.forEach((k, v) -> {
            ElementInfo info = ELEMENT_INFO.get(k);
            if (info != null) {
                info.setPosition((Vector2f)v);
            }
        });
        HashMap toWrite = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, ElementInfo> entry : ELEMENT_INFO.entrySet()) {
            toWrite.put(entry.getKey().toString(), entry.getValue().getPosition());
        }
        String json = GSON.toJson((Object)toWrite);
        try (FileWriter writer = new FileWriter(CONFIG);){
            writer.write(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void readConfig() {
        if (!CONFIG.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(CONFIG);){
            Map toLoad = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, Vector2f>>(){}.getType());
            for (Map.Entry entry : toLoad.entrySet()) {
                ElementInfo info = ELEMENT_INFO.get(new ResourceLocation((String)entry.getKey()));
                if (info == null) continue;
                info.setPosition((Vector2f)entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
            for (HUDElement element : HUD_ELEMENTS.values()) {
                int yPos;
                if (!element.shouldRender(Minecraft.func_71410_x())) continue;
                Vector2f position = ELEMENT_INFO.get(ElementRegistry.getKey(element)).getPosition();
                int xPos = (int)(resolution.func_78327_c() * (double)position.x);
                if (xPos - element.getWidth() < 0) {
                    xPos *= 2;
                }
                if (xPos + element.getWidth() > resolution.func_78326_a()) {
                    xPos -= element.getWidth();
                }
                if ((yPos = (int)(resolution.func_78324_d() * (double)position.y)) - element.getHeight() < 0) {
                    yPos *= 2;
                }
                if (yPos + element.getHeight() > resolution.func_78328_b()) {
                    yPos -= element.getHeight();
                }
                element.draw(event.getResolution(), event.getPartialTicks(), xPos, yPos);
            }
        }
    }

    public static int getRandomColor() {
        Random rand = new Random();
        float r = rand.nextFloat() / 2.0f + 0.5f;
        float g = rand.nextFloat() / 2.0f + 0.5f;
        float b = rand.nextFloat() / 2.0f + 0.5f;
        float a = 0.5f;
        return new Color(r, g, b, a).getRGB();
    }
}

