/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript.script.object;

import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import me.superckl.api.superscript.APIInfo;
import me.superckl.api.superscript.script.ScriptContext;
import me.superckl.api.superscript.script.ScriptHandler;
import me.superckl.api.superscript.script.ScriptParser;
import me.superckl.api.superscript.script.command.ScriptCommand;
import me.superckl.api.superscript.script.command.ScriptCommandListing;
import me.superckl.api.superscript.script.command.ScriptCommandRegistry;
import me.superckl.api.superscript.util.CollectionHelper;
import me.superckl.api.superscript.util.WarningHelper;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ScriptObject {
    protected final Map<String, ScriptCommandListing> validCommands = new LinkedHashMap<String, ScriptCommandListing>();
    private ScriptContext context;

    public ScriptObject() {
        Class<?> clazz = this.getClass();
        while (ScriptObject.class.isAssignableFrom(clazz)) {
            this.validCommands.putAll(ScriptCommandRegistry.INSTANCE.getListings((Class)WarningHelper.uncheckedCast(clazz)));
            clazz = clazz.getSuperclass();
        }
    }

    public void handleCall(String call, ScriptContext context, ScriptHandler handler) throws Exception {
        String command;
        try {
            command = ScriptParser.getCommandCalled(call);
        }
        catch (IllegalArgumentException e) {
            APIInfo.log.error("Failed to parse command call: " + call + " @ " + context + ". Reason: " + e.getMessage());
            return;
        }
        if (!this.validCommands.containsKey(command)) {
            APIInfo.log.error("Failed to find meaning in command " + call + " @ " + context + ". Reason: No commands found with that name.");
            return;
        }
        ScriptCommandListing listing = this.validCommands.get(command);
        String[] args = CollectionHelper.trimAll(ScriptParser.parseArguments(call));
        Pair<Constructor<? extends ScriptCommand>, Object[]> pair = ScriptParser.findConstructor(listing, args = this.modifyArguments(args, handler), handler);
        if (pair != null) {
            pair = this.modifyConstructorPair(pair, args, handler);
            ScriptCommand sCommand = (ScriptCommand)((Constructor)pair.getKey()).newInstance((Object[])pair.getValue());
            sCommand.setContext(context);
            sCommand.setScriptHandler(handler);
            if (listing.isPerformInst()) {
                sCommand.perform();
            } else {
                this.addCommand(sCommand);
            }
            return;
        }
        APIInfo.log.error("Failed to parse arguments for command " + call + " @ " + context + ". Reason: No constructors found with matching arguments.");
    }

    public void readArgs(Object ... args) throws Exception {
    }

    public abstract void addCommand(ScriptCommand var1);

    public Map<String, ScriptCommandListing> getValidCommands() {
        return this.validCommands;
    }

    public Pair<Constructor<? extends ScriptCommand>, Object[]> modifyConstructorPair(Pair<Constructor<? extends ScriptCommand>, Object[]> pair, String[] args, ScriptHandler handler) {
        return pair;
    }

    public String[] modifyArguments(String[] args, ScriptHandler handler) {
        return args;
    }

    public void setContext(ScriptContext context) {
        if (this.context != null) {
            throw new IllegalStateException("Context has already been set!");
        }
        this.context = context;
    }

    public ScriptContext getContext() {
        return this.context;
    }
}

