/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.block.BlockBOPGeneric;
import biomesoplenty.common.util.biome.BiomeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class BlockBOPBiomeBlock
extends BlockBOPGeneric {
    private static List<Biome> biomesWithEssence;

    public BlockBOPBiomeBlock() {
        super(Material.field_151592_s, SoundType.field_185853_f);
        this.func_149711_c(0.6f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public List<Biome> getBiomesWithEssence() {
        if (biomesWithEssence != null) {
            return biomesWithEssence;
        }
        biomesWithEssence = new ArrayList<Biome>();
        List<Biome> vanillaBiomesToExclude = Arrays.asList(Biomes.field_180279_ad, Biomes.field_76779_k, Biomes.field_76778_j, Biomes.field_76787_r, Biomes.field_150577_O, Biomes.field_150576_N, Biomes.field_76771_b, Biomes.field_76776_l, Biomes.field_150575_M, Biomes.field_76781_i, Biomes.field_76777_m, Biomes.field_185440_P, Biomes.field_76788_q, Biomes.field_76786_s, Biomes.field_150582_Q, Biomes.field_150579_T, Biomes.field_76783_v, Biomes.field_150580_W, Biomes.field_76785_t, Biomes.field_76775_o, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_150608_ab, Biomes.field_150607_aa, Biomes.field_185448_Z, Biomes.field_185429_aa, Biomes.field_185442_R, Biomes.field_185443_S, Biomes.field_185434_af, Biomes.field_185444_T, Biomes.field_185445_W, Biomes.field_185446_X, Biomes.field_185447_Y, Biomes.field_185437_ai, Biomes.field_185439_ak, Biomes.field_185438_aj, Biomes.field_185441_Q, Biomes.field_185432_ad, Biomes.field_185433_ae, Biomes.field_185430_ab, Biomes.field_185435_ag, Biomes.field_185436_ah, Biomes.field_150599_m, Biomes.field_150590_f, Biomes.field_185431_ac, Biomes.field_150581_V, Biomes.field_150587_Y, Biomes.field_76784_u);
        for (Biome biome : BiomeUtils.getRegisteredBiomes()) {
            if (biome == null) continue;
            if (biome instanceof BOPBiome) {
                if (!((BOPBiome)biome).hasBiomeEssence()) continue;
                biomesWithEssence.add(biome);
                continue;
            }
            if (vanillaBiomesToExclude.contains(biome)) continue;
            biomesWithEssence.add(biome);
        }
        return biomesWithEssence;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        List<Biome> biomes = this.getBiomesWithEssence();
        int numToDrop = rand.nextInt(fortune + 1) + 1;
        int numChoices = biomes.size();
        for (int i = 0; i < numToDrop; ++i) {
            Biome biome = biomes.get(rand.nextInt(numChoices));
            ItemStack biome_essence = new ItemStack(BOPItems.biome_essence);
            biome_essence.func_77982_d(new NBTTagCompound());
            biome_essence.func_77978_p().func_74768_a("biomeID", Biome.func_185362_a((Biome)biome));
            ret.add(biome_essence);
        }
        return ret;
    }
}

