/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.betterdisplays.client.renderer;

import com.windanesz.betterdisplays.BetterDisplays;
import com.windanesz.betterdisplays.client.ClientEventHandler;
import com.windanesz.betterdisplays.client.model.ModelDisplayCase;
import com.windanesz.betterdisplays.tileentity.TileEntityDisplayCase;
import java.util.Map;
import java.util.StringTokenizer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class RenderDisplayCase
extends TileEntitySpecialRenderer<TileEntityDisplayCase> {
    private static final float SCALE = 0.0625f;
    private final ModelDisplayCase model = new ModelDisplayCase();
    private ResourceLocation cachedMainTexture = new ResourceLocation("minecraft:textures/blocks/planks_oak.png");
    private ResourceLocation cachedGlassTexture = new ResourceLocation("betterdisplays:blocks/glass");
    private IBlockState cachedMainBlockState = Blocks.field_150344_f.func_176223_P();
    private IBlockState cachedGlassBlockState = Blocks.field_150359_w.func_176223_P();

    public ModelDisplayCase getModel() {
        return this.model;
    }

    public void render(TileEntityDisplayCase tileentity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState cachedGlassBlockState;
        String glassString;
        StringTokenizer stringTokenizerGlass;
        IBlockState cachedCarpetBlockState;
        String carpetString;
        StringTokenizer stringTokenizerCarpet;
        boolean hasItem = !tileentity.getStack().func_190926_b();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        int rotX = tileentity.getXRotation();
        int rotY = tileentity.getYRotation();
        int rotZ = tileentity.getZRotation();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)this.getItemYOffset(), (float)0.0f);
        if (rotX != 0) {
            GlStateManager.func_179114_b((float)((float)rotX * 360.0f / 8.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (rotY != 0) {
            GlStateManager.func_179114_b((float)((float)rotY * 360.0f / 8.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rotZ != 0) {
            GlStateManager.func_179114_b((float)((float)rotZ * 360.0f / 8.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        float t = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks;
        this.renderItem(tileentity, 1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179109_b((float)0.5f, (float)-1.0f, (float)-0.5f);
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        GlStateManager.func_179094_E();
        IBlockState cachedMainBlockState = tileentity.getMainBlock();
        String mainMaterialString = ((BakedQuad)dispatcher.func_184389_a(cachedMainBlockState).func_188616_a(cachedMainBlockState, EnumFacing.NORTH, 0L).get(0)).func_187508_a().func_94215_i();
        StringTokenizer stringTokenizerMainMaterial = new StringTokenizer(mainMaterialString, ":");
        if (stringTokenizerMainMaterial.countTokens() == 2) {
            String namespace = stringTokenizerMainMaterial.nextToken();
            String path = namespace + ":textures/" + stringTokenizerMainMaterial.nextToken() + ".png";
            ResourceLocation MainTexture = new ResourceLocation(path);
            this.func_147499_a(MainTexture);
            this.getModel().renderCase(0.0625f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
        }
        if ((stringTokenizerCarpet = new StringTokenizer(carpetString = ((BakedQuad)dispatcher.func_184389_a(cachedCarpetBlockState = tileentity.getCarpetBlock()).func_188616_a(cachedCarpetBlockState, EnumFacing.NORTH, 0L).get(0)).func_187508_a().func_94215_i(), ":")).countTokens() == 2) {
            String namespace = stringTokenizerCarpet.nextToken();
            String path = namespace + ":textures/" + stringTokenizerCarpet.nextToken() + ".png";
            ResourceLocation carpetTexture = new ResourceLocation(path);
            this.func_147499_a(carpetTexture);
            GlStateManager.func_179126_j();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179147_l();
            this.getModel().renderCarpet(0.0625f);
            GlStateManager.func_179084_k();
        }
        if ((stringTokenizerGlass = new StringTokenizer(glassString = ((BakedQuad)dispatcher.func_184389_a(cachedGlassBlockState = tileentity.getGlassBlock()).func_188616_a(cachedGlassBlockState, EnumFacing.NORTH, 0L).get(0)).func_187508_a().func_94215_i(), ":")).countTokens() == 2) {
            String namespace = stringTokenizerGlass.nextToken();
            String path = namespace + ":textures/" + stringTokenizerGlass.nextToken() + ".png";
            ResourceLocation GlassTexture = new ResourceLocation(path);
            this.func_147499_a(GlassTexture);
            GlStateManager.func_179126_j();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179147_l();
            this.getModel().renderGlass(0.0625f);
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        this.renderContainedItemNameplate(tileentity, hasItem, x, y, z);
    }

    private void renderContainedItemNameplate(TileEntityDisplayCase tileentity, boolean hasItem, double x, double y, double z) {
        if (BetterDisplays.settings.displayItemNames && hasItem) {
            if (BetterDisplays.settings.displayItemNamesOnlyWhileSneaking && !Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
                return;
            }
            String displayString = tileentity.getStack().func_82833_r();
            if (ClientEventHandler.lastBlockPosResult != null && ClientEventHandler.lastBlockPosResult.equals((Object)tileentity.func_174877_v())) {
                if (tileentity.getStack().func_77973_b() == Items.field_151134_bR) {
                    float yOffset = 0.0f;
                    this.func_190052_a(tileentity, displayString, x, y + (double)0.2f, z, 4);
                    for (Map.Entry enchantment : EnchantmentHelper.func_82781_a((ItemStack)tileentity.getStack()).entrySet()) {
                        this.func_190052_a(tileentity, ((Enchantment)enchantment.getKey()).func_77316_c(((Integer)enchantment.getValue()).intValue()), x, y + (double)0.2f + (double)(yOffset += -0.3f), z, 4);
                    }
                } else {
                    this.func_190052_a(tileentity, displayString, x, y, z, 4);
                }
            }
        }
    }

    private void renderItem(TileEntityDisplayCase tileentity, float t) {
        ItemStack stack = tileentity.getStack();
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)t, (float)0.0f, (float)1.0f, (float)0.0f);
            float scale = 0.85f;
            if (stack.func_82833_r().contains("Dragon Head") || stack.func_82833_r().contains("Awakened Hoe") || stack.func_82833_r().contains("Awakened Bow") || stack.func_82833_r().contains("Wyvern Bow")) {
                scale = 0.4f;
            } else if (stack.func_82833_r().contains("Sword")) {
                scale = 0.8f;
            }
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
        }
    }

    public float getItemYOffset() {
        return -0.02f;
    }
}

