/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.util;

import com.google.common.collect.ImmutableList;
import com.teamacronymcoders.base.Base;
import com.teamacronymcoders.base.items.ItemBaseNoModel;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class TinkersUtils {
    private static boolean canBreakExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos, BlockPos refPos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!TinkersUtils.isToolEffective(stack, state)) {
            return false;
        }
        IBlockState refState = world.func_180495_p(refPos);
        float refStrength = ForgeHooks.blockStrength((IBlockState)refState, (EntityPlayer)player, (World)world, (BlockPos)refPos);
        float strength = ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, player, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K) {
                world.func_184138_a(pos, state, world.func_180495_p(pos), 2);
            }
            return false;
        }
        return true;
    }

    public static void breakExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos, BlockPos refPos) {
        if (!TinkersUtils.canBreakExtraBlock(stack, world, player, pos, refPos)) {
            return;
        }
        Base.instance.getLogger().devInfo("Could break block");
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        stack.func_179548_a(world, state, pos, player);
        if (!world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
            if (xp == -1) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, tileEntity, stack);
                block.func_180637_b(world, pos, xp);
            }
            world.func_184138_a(pos, state, world.func_180495_p(pos), 2);
        } else {
            world.func_175669_a(2001, pos, Block.func_176210_f((IBlockState)state));
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
            }
            stack.func_179548_a(world, state, pos, player);
            if (stack.func_190916_E() == 0 && stack == player.func_184614_ca()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)EnumHand.MAIN_HAND);
                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
            NetHandlerPlayClient netHandlerPlayClient = Minecraft.func_71410_x().func_147114_u();
            assert (netHandlerPlayClient != null);
            netHandlerPlayClient.func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
    }

    public static boolean isToolEffective(ItemStack stack, IBlockState state) {
        for (String type : stack.func_77973_b().getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin, int width, int height, int depth, int distance) {
        int z;
        int y;
        int x;
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBaseNoModel)) {
            return ImmutableList.of();
        }
        IBlockState state = world.func_180495_p(origin);
        if (!TinkersUtils.isToolEffective(stack, state)) {
            return ImmutableList.of();
        }
        RayTraceResult mop = ((ItemBaseNoModel)stack.func_77973_b()).func_77621_a(world, player, true);
        if (!(mop != null && origin.equals((Object)mop.func_178782_a()) || (mop = ((ItemBaseNoModel)stack.func_77973_b()).func_77621_a(world, player, false)) != null && origin.equals((Object)mop.func_178782_a()))) {
            return ImmutableList.of();
        }
        BlockPos start = origin;
        switch (mop.field_178784_b) {
            case DOWN: 
            case UP: {
                Vec3i vec = player.func_174811_aO().func_176730_m();
                x = vec.func_177958_n() * height + vec.func_177952_p() * width;
                y = mop.field_178784_b.func_176743_c().func_179524_a() * -depth;
                z = vec.func_177958_n() * width + vec.func_177952_p() * height;
                start = start.func_177982_a(-x / 2, 0, -z / 2);
                if (x % 2 == 0) {
                    if (x > 0 && mop.field_72307_f.field_72450_a - (double)mop.func_178782_a().func_177958_n() > 0.5) {
                        start = start.func_177982_a(1, 0, 0);
                    } else if (x < 0 && mop.field_72307_f.field_72450_a - (double)mop.func_178782_a().func_177958_n() < 0.5) {
                        start = start.func_177982_a(-1, 0, 0);
                    }
                }
                if (z % 2 != 0) break;
                if (z > 0 && mop.field_72307_f.field_72449_c - (double)mop.func_178782_a().func_177952_p() > 0.5) {
                    start = start.func_177982_a(0, 0, 1);
                    break;
                }
                if (z >= 0 || !(mop.field_72307_f.field_72449_c - (double)mop.func_178782_a().func_177952_p() < 0.5)) break;
                start = start.func_177982_a(0, 0, -1);
                break;
            }
            case NORTH: 
            case SOUTH: {
                x = width;
                y = height;
                z = mop.field_178784_b.func_176743_c().func_179524_a() * -depth;
                start = start.func_177982_a(-x / 2, -y / 2, 0);
                if (x % 2 == 0 && mop.field_72307_f.field_72450_a - (double)mop.func_178782_a().func_177958_n() > 0.5) {
                    start = start.func_177982_a(1, 0, 0);
                }
                if (y % 2 != 0 || !(mop.field_72307_f.field_72448_b - (double)mop.func_178782_a().func_177956_o() > 0.5)) break;
                start = start.func_177982_a(0, 1, 0);
                break;
            }
            case WEST: 
            case EAST: {
                x = mop.field_178784_b.func_176743_c().func_179524_a() * -depth;
                y = height;
                z = width;
                start = start.func_177982_a(0, -y / 2, -z / 2);
                if (y % 2 == 0 && mop.field_72307_f.field_72448_b - (double)mop.func_178782_a().func_177956_o() > 0.5) {
                    start = start.func_177982_a(0, 1, 0);
                }
                if (z % 2 != 0 || !(mop.field_72307_f.field_72449_c - (double)mop.func_178782_a().func_177952_p() > 0.5)) break;
                start = start.func_177982_a(0, 0, 1);
                break;
            }
            default: {
                z = 0;
                y = 0;
                x = 0;
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int xp = start.func_177958_n(); xp != start.func_177958_n() + x; xp += x / MathHelper.func_76130_a((int)x)) {
            for (int yp = start.func_177956_o(); yp != start.func_177956_o() + y; yp += y / MathHelper.func_76130_a((int)y)) {
                for (int zp = start.func_177952_p(); zp != start.func_177952_p() + z; zp += z / MathHelper.func_76130_a((int)z)) {
                    BlockPos pos;
                    if (xp == origin.func_177958_n() && yp == origin.func_177956_o() && zp == origin.func_177952_p() || distance > 0 && MathHelper.func_76130_a((int)(xp - origin.func_177958_n())) + MathHelper.func_76130_a((int)(yp - origin.func_177956_o())) + MathHelper.func_76130_a((int)(zp - origin.func_177952_p())) > distance || !TinkersUtils.isToolEffective(stack, world.func_180495_p(pos = new BlockPos(xp, yp, zp)))) continue;
                    builder.add((Object)pos);
                }
            }
        }
        return builder.build();
    }
}

