/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.recipesystem.handler;

import com.teamacronymcoders.base.recipesystem.Recipe;
import com.teamacronymcoders.base.recipesystem.RecipeContainer;
import com.teamacronymcoders.base.recipesystem.handler.IRecipeHandler;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;

public class DefaultRecipeHandler
implements IRecipeHandler {
    private final List<Recipe> recipes;
    private Recipe currentRecipe = null;
    private int waiting = 0;

    public DefaultRecipeHandler(List<Recipe> recipes) {
        this.recipes = recipes;
    }

    @Override
    public boolean handleRecipe(RecipeContainer recipeContainer, @Nullable EntityPlayer entityPlayer) {
        if (this.waiting > 0) {
            --this.waiting;
        }
        if (this.currentRecipe == null && this.waiting <= 0) {
            Iterator<Recipe> recipeIterator = this.recipes.iterator();
            while (this.currentRecipe == null && recipeIterator.hasNext()) {
                Recipe recipe = recipeIterator.next();
                if (!recipe.matches(recipeContainer, entityPlayer)) continue;
                this.currentRecipe = recipe;
            }
            this.waiting = 100;
        }
        if (this.currentRecipe != null) {
            if (this.currentRecipe.matches(recipeContainer, entityPlayer)) {
                if (this.currentRecipe.canOutput(recipeContainer)) {
                    this.currentRecipe.doOutput(recipeContainer);
                    return true;
                }
            } else {
                this.currentRecipe = null;
            }
        }
        return false;
    }

    @Override
    public void reloadRecipes(List<Recipe> recipeList) {
        this.recipes.clear();
        this.recipes.addAll(recipeList);
    }
}

