/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered.powersink;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import appeng.util.Platform;
import java.text.MessageFormat;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AEBasePoweredItem
extends AEBaseItem
implements IAEItemPowerStorage {
    private static final String CURRENT_POWER_NBT_KEY = "internalCurrentPower";
    private static final String MAX_POWER_NBT_KEY = "internalMaxPower";
    private final double powerCapacity;

    public AEBasePoweredItem(double powerCapacity) {
        this.func_77625_d(1);
        this.func_77656_e(32);
        this.field_77787_bX = false;
        this.func_77664_n();
        this.powerCapacity = powerCapacity;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        NBTTagCompound tag = stack.func_77978_p();
        double internalCurrentPower = 0.0;
        double internalMaxPower = this.getAEMaxPower(stack);
        if (tag != null) {
            internalCurrentPower = tag.func_74769_h(CURRENT_POWER_NBT_KEY);
        }
        double percent = internalCurrentPower / internalMaxPower;
        lines.add(GuiText.StoredEnergy.getLocal() + ':' + MessageFormat.format(" {0,number,#} ", internalCurrentPower) + Platform.gui_localize(PowerUnits.AE.unlocalizedName) + " - " + MessageFormat.format(" {0,number,#.##%} ", percent));
    }

    public boolean func_77645_m() {
        return true;
    }

    @Override
    protected void getCheckedSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> itemStacks) {
        super.getCheckedSubItems(creativeTab, itemStacks);
        ItemStack charged = new ItemStack((Item)this, 1);
        NBTTagCompound tag = Platform.openNbtData(charged);
        tag.func_74780_a(CURRENT_POWER_NBT_KEY, this.getAEMaxPower(charged));
        tag.func_74780_a(MAX_POWER_NBT_KEY, this.getAEMaxPower(charged));
        itemStacks.add((Object)charged);
    }

    public boolean isRepairable() {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack is) {
        return 1.0 - this.getAECurrentPower(is) / this.getAEMaxPower(is);
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    @Override
    public double injectAEPower(ItemStack is, double amount, Actionable mode) {
        double maxStorage = this.getAEMaxPower(is);
        double currentStorage = this.getAECurrentPower(is);
        double required = maxStorage - currentStorage;
        double overflow = amount - required;
        if (mode == Actionable.MODULATE) {
            NBTTagCompound data = Platform.openNbtData(is);
            double toAdd = Math.min(amount, required);
            data.func_74780_a(CURRENT_POWER_NBT_KEY, currentStorage + toAdd);
        }
        return Math.max(0.0, overflow);
    }

    @Override
    public double extractAEPower(ItemStack is, double amount, Actionable mode) {
        return amount;
    }

    @Override
    public double getAEMaxPower(ItemStack is) {
        return this.powerCapacity;
    }

    @Override
    public double getAECurrentPower(ItemStack is) {
        NBTTagCompound data = Platform.openNbtData(is);
        return data.func_74769_h(CURRENT_POWER_NBT_KEY);
    }

    @Override
    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new PoweredItemCapabilities(stack, this);
    }
}

