/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.config.CopyMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.slot.OptionalSlotRestrictedInput;
import appeng.container.slot.SlotFakeTypeOnly;
import appeng.container.slot.SlotRestrictedInput;
import appeng.tile.misc.TileCellWorkbench;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.WrapperSupplierItemHandler;
import appeng.util.iterators.NullIterator;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ContainerCellWorkbench
extends ContainerUpgradeable {
    private final TileCellWorkbench workBench;
    @GuiSync(value=2)
    public CopyMode copyMode = CopyMode.CLEAR_ON_REMOVE;
    private ItemStack prevStack = ItemStack.field_190927_a;
    private int lastUpgrades = 0;

    public ContainerCellWorkbench(InventoryPlayer ip, TileCellWorkbench te) {
        super(ip, te);
        this.workBench = te;
    }

    public void setFuzzy(FuzzyMode valueOf) {
        ICellWorkbenchItem cwi = this.workBench.getCell();
        if (cwi != null) {
            cwi.setFuzzyMode(this.workBench.getInventoryByName("cell").getStackInSlot(0), valueOf);
        }
    }

    public void nextWorkBenchCopyMode() {
        this.workBench.getConfigManager().putSetting(Settings.COPY_MODE, Platform.nextEnum(this.getWorkBenchCopyMode()));
    }

    private CopyMode getWorkBenchCopyMode() {
        return (CopyMode)this.workBench.getConfigManager().getSetting(Settings.COPY_MODE);
    }

    @Override
    protected int getHeight() {
        return 251;
    }

    @Override
    protected void setupConfig() {
        int z;
        IItemHandler cell = this.getUpgradeable().getInventoryByName("cell");
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.WORKBENCH_CELL, cell, 0, 152, 8, this.getPlayerInv()));
        IItemHandler inv = this.getUpgradeable().getInventoryByName("config");
        WrapperSupplierItemHandler upgradeInventory = new WrapperSupplierItemHandler(this::getCellUpgradeInventory);
        int offset = 0;
        int y = 29;
        int x = 8;
        for (int w = 0; w < 7; ++w) {
            for (z = 0; z < 9; ++z) {
                this.func_75146_a(new SlotFakeTypeOnly(inv, offset, 8 + z * 18, 29 + w * 18));
                ++offset;
            }
        }
        for (int zz = 0; zz < 3; ++zz) {
            for (z = 0; z < 8; ++z) {
                int iSLot = zz * 8 + z;
                this.func_75146_a(new OptionalSlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, (IItemHandler)upgradeInventory, this, iSLot, 187 + zz * 18, 8 + 18 * z, iSLot, this.getInventoryPlayer()));
            }
        }
    }

    @Override
    public int availableUpgrades() {
        ItemStack is = this.workBench.getInventoryByName("cell").getStackInSlot(0);
        if (this.prevStack != is) {
            this.prevStack = is;
            this.lastUpgrades = this.getCellUpgradeInventory().getSlots();
        }
        return this.lastUpgrades;
    }

    @Override
    public void func_75142_b() {
        ItemStack is = this.workBench.getInventoryByName("cell").getStackInSlot(0);
        if (Platform.isServer()) {
            for (IContainerListener listener : this.field_75149_d) {
                if (this.prevStack == is) continue;
                for (Slot s : this.field_75151_b) {
                    if (!(s instanceof OptionalSlotRestrictedInput)) continue;
                    OptionalSlotRestrictedInput sri = (OptionalSlotRestrictedInput)s;
                    listener.func_71111_a((Container)this, sri.field_75222_d, sri.func_75211_c());
                }
                if (!(listener instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)listener).field_71137_h = false;
            }
            this.setCopyMode(this.getWorkBenchCopyMode());
            this.setFuzzyMode(this.getWorkBenchFuzzyMode());
        }
        this.prevStack = is;
        this.standardDetectAndSendChanges();
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        return idx < this.availableUpgrades();
    }

    public IItemHandler getCellUpgradeInventory() {
        IItemHandler upgradeInventory = this.workBench.getCellUpgradeInventory();
        return upgradeInventory == null ? EmptyHandler.INSTANCE : upgradeInventory;
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("copyMode")) {
            this.workBench.getConfigManager().putSetting(Settings.COPY_MODE, this.getCopyMode());
        }
        super.onUpdate(field, oldValue, newValue);
    }

    public void clear() {
        ItemHandlerUtil.clear(this.getUpgradeable().getInventoryByName("config"));
        this.func_75142_b();
    }

    private FuzzyMode getWorkBenchFuzzyMode() {
        ICellWorkbenchItem cwi = this.workBench.getCell();
        if (cwi != null) {
            return cwi.getFuzzyMode(this.workBench.getInventoryByName("cell").getStackInSlot(0));
        }
        return FuzzyMode.IGNORE_ALL;
    }

    public void partition() {
        IItemHandler inv = this.getUpgradeable().getInventoryByName("config");
        ItemStack is = this.getUpgradeable().getInventoryByName("cell").getStackInSlot(0);
        IItemStorageChannel channel = is.func_77973_b() instanceof IStorageCell ? ((IStorageCell)is.func_77973_b()).getChannel() : AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        ICellInventoryHandler<IAEItemStack> cellInv = AEApi.instance().registries().cell().getCellInventory(is, null, channel);
        Iterator i = new NullIterator();
        if (cellInv != null) {
            IItemList list = cellInv.getAvailableItems(channel.createList());
            i = list.iterator();
        }
        for (int x = 0; x < inv.getSlots(); ++x) {
            if (i.hasNext()) {
                ItemStack g = ((IAEStack)i.next()).asItemStackRepresentation();
                ItemHandlerUtil.setStackInSlot(inv, x, g);
                continue;
            }
            ItemHandlerUtil.setStackInSlot(inv, x, ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    public CopyMode getCopyMode() {
        return this.copyMode;
    }

    private void setCopyMode(CopyMode copyMode) {
        this.copyMode = copyMode;
    }
}

