/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.proxy;

import cofh.core.util.helpers.ItemHelper;
import cofh.thermalfoundation.init.TFProps;
import cofh.thermalfoundation.item.ItemMaterial;
import cofh.thermalfoundation.item.tome.ItemTomeExperience;
import cofh.thermalfoundation.util.LexiconManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandler {
    public static final EventHandler INSTANCE = new EventHandler();

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void handleLivingDropsEvent(LivingDropsEvent event) {
        Entity entity = event.getEntity();
        if (entity.func_70045_F() && TFProps.dropSulfurFireImmuneMobs && event.getEntityLiving().field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            boolean s = entity instanceof EntitySlime;
            if (event.getEntityLiving().func_70681_au().nextInt(6 + (s ? 16 : 0)) != 0) {
                return;
            }
            event.getDrops().add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ItemMaterial.dustSulfur.func_77946_l()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleEntityItemPickupEvent(EntityItemPickupEvent event) {
        EntityItem item = event.getItem();
        ItemStack stack = item.func_92059_d();
        if (stack.func_190926_b() || !LexiconManager.validOre(stack)) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        NBTTagCompound tag = player.getEntityData();
        if (player.field_70170_p.func_82737_E() - tag.func_74763_f("thermalfoundation.lexicon_timer") > 20L) {
            return;
        }
        ItemStack lexiconStack = LexiconManager.getPreferredStack(player, stack);
        if (ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)lexiconStack)) {
            return;
        }
        item.func_92058_a(lexiconStack.func_77946_l());
        event.setCanceled(true);
        item.func_70100_b_(player);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void handlePlayerCloneEvent(PlayerEvent.Clone event) {
        NBTTagCompound newTag = event.getEntityPlayer().getEntityData();
        NBTTagCompound oldTag = event.getOriginal().getEntityData();
        if (oldTag.func_74764_b("thermalfoundation.lexicon_data")) {
            newTag.func_74782_a("thermalfoundation.lexicon_data", (NBTBase)oldTag.func_74775_l("thermalfoundation.lexicon_data"));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void handlePlayerPickupXpEvent(PlayerPickupXpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        NBTTagCompound tag = player.getEntityData();
        if (player.field_70170_p.func_82737_E() - tag.func_74763_f("thermalfoundation.experience_timer") > 20L) {
            return;
        }
        InventoryPlayer inventory = player.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemTomeExperience) || !ItemTomeExperience.onXPPickup(event, stack)) continue;
            event.setCanceled(true);
            return;
        }
    }
}

