/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.world.gen.base;

import java.util.Random;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BaseDeck;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BaseRoom;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;

public class BaseConfiguration {
    private static final int HANGAR_AIRLOCK_HEIGHT = 7;
    private static final int HANGAR_AIRLOCK_WIDTH = 7;
    private final BaseRoom.EnumRoomType[] roomTypes = BaseRoom.EnumRoomType.values();
    private int yPosition;
    private int baseType;
    private boolean hangar;
    private int roomHeight;
    private int roomDepth;
    private IBlockState wallBlock;
    private int roomsNo;
    private int[] randomRoomTypes;

    public BaseConfiguration() {
    }

    public BaseConfiguration(int yPosition, Random rand) {
        BaseDeck.EnumBaseType[] types = BaseDeck.EnumBaseType.values();
        this.yPosition = yPosition - 2 + rand.nextInt(5);
        this.baseType = rand.nextInt(types.length);
        this.hangar = true;
        this.roomHeight = types[this.baseType].height;
        this.roomDepth = this.hangar ? 7 : rand.nextInt(3) + 5;
        this.wallBlock = types[this.baseType].wall;
        this.roomsNo = rand.nextInt(2) + 2;
        this.createRandomRoomList(rand);
    }

    private void createRandomRoomList(Random rand) {
        int range = this.roomTypes.length;
        int size = this.hangar ? 8 : this.roomsNo * 6;
        this.randomRoomTypes = new int[size];
        for (int i = 0; i < size; ++i) {
            this.randomRoomTypes[i] = i % range;
        }
        for (int i = size - 1; i > 0; --i) {
            int index = rand.nextInt(i + 1);
            if (i == index) continue;
            int temp = this.randomRoomTypes[index];
            this.randomRoomTypes[index] = this.randomRoomTypes[i];
            this.randomRoomTypes[i] = temp;
        }
        if (this.hangar) {
            boolean storeFound = false;
            for (int i = 0; i < 4; ++i) {
                if (this.randomRoomTypes[i] != BaseRoom.EnumRoomType.STORE.ordinal()) continue;
                storeFound = true;
                break;
            }
            if (!storeFound) {
                this.randomRoomTypes[rand.nextInt((int)4)] = BaseRoom.EnumRoomType.STORE.ordinal();
            }
        }
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("yPos", this.yPosition);
        tagCompound.func_74768_a("dT", this.baseType + (this.hangar ? 16 : 0));
        tagCompound.func_74768_a("rmD", this.roomDepth);
        tagCompound.func_74768_a("rmN", this.roomsNo);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        try {
            this.yPosition = tagCompound.func_74762_e("yPos");
            this.baseType = tagCompound.func_74762_e("dT");
            this.hangar = false;
            if (this.baseType >= 16) {
                this.hangar = true;
                this.baseType -= 16;
            }
            this.roomDepth = tagCompound.func_74762_e("rmD");
            this.roomsNo = tagCompound.func_74762_e("rmN");
            this.roomHeight = BaseDeck.EnumBaseType.values()[this.baseType].height;
            this.wallBlock = BaseDeck.EnumBaseType.values()[this.baseType].wall;
        }
        catch (Exception e) {
            System.err.println("Failed to read Abandoned Base configuration from NBT");
            System.err.println(tagCompound.toString());
        }
    }

    public int getYPosition() {
        return this.yPosition;
    }

    public IBlockState getWallBlock() {
        return this.wallBlock;
    }

    public int getRoomHeight() {
        return this.hangar ? 7 : this.roomHeight;
    }

    public int getRoomDepth() {
        return this.roomDepth;
    }

    public BaseDeck.EnumBaseType getDeckType() {
        return BaseDeck.EnumBaseType.values()[this.baseType];
    }

    public boolean isHangarDeck() {
        return this.hangar;
    }

    public int getCorridorWidth() {
        return this.hangar ? 7 : this.getDeckType().width;
    }

    public int getRoomsNo() {
        return this.hangar ? 2 : this.roomsNo;
    }

    public int getCorridorLength() {
        if (this.getRoomsNo() == 1) {
            return 8;
        }
        if (this.getRoomsNo() == 2) {
            return 16;
        }
        return this.getRoomsNo() * 6 + 4;
    }

    public BaseRoom.EnumRoomType getRandomRoom(int i) {
        return this.roomTypes[this.randomRoomTypes[i % this.randomRoomTypes.length]];
    }
}

