/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementTextBox;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.planets.mars.inventory.ContainerLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.network.PacketSimpleMars;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class GuiLaunchController
extends GuiContainerGC
implements GuiElementTextBox.ITextBoxCallback {
    private static final ResourceLocation launchControllerGui = new ResourceLocation("galacticraftplanets", "textures/gui/launch_controller.png");
    private final TileEntityLaunchController launchController;
    private final GuiElementInfoRegion electricInfoRegion = new GuiElementInfoRegion(0, 0, 52, 9, null, 0, 0, (GuiContainerGC)this);
    private final GuiElementInfoRegion waterTankInfoRegion = new GuiElementInfoRegion(0, 0, 41, 28, null, 0, 0, (GuiContainerGC)this);
    private GuiButton enableControllerButton;
    private GuiButton hideDestinationFrequency;
    private GuiButton openAdvancedConfig;
    private GuiElementTextBox frequency;
    private GuiElementTextBox destinationFrequency;
    private int cannotEditTimer;

    public GuiLaunchController(InventoryPlayer playerInventory, TileEntityLaunchController launchController) {
        super((Container)new ContainerLaunchController(playerInventory, launchController, (EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g));
        this.field_147000_g = 209;
        this.launchController = launchController;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int k;
        if (this.launchController.disableCooldown > 0) {
            this.enableControllerButton.field_146124_l = false;
            this.hideDestinationFrequency.field_146124_l = false;
        } else {
            boolean isOwner;
            this.enableControllerButton.field_146124_l = isOwner = PlayerUtil.getName((EntityPlayer)this.field_146297_k.field_71439_g).equals(this.launchController.getOwnerName());
            this.hideDestinationFrequency.field_146124_l = isOwner;
        }
        this.enableControllerButton.field_146126_j = this.launchController.getDisabled(0) ? GCCoreUtil.translate((String)"gui.button.enable.name") : GCCoreUtil.translate((String)"gui.button.disable.name");
        this.hideDestinationFrequency.field_146126_j = !this.launchController.getDisabled(2) ? GCCoreUtil.translate((String)"gui.button.unhide_dest.name") : GCCoreUtil.translate((String)"gui.button.hide_dest.name");
        ArrayList buttonList = new ArrayList(this.field_146292_n);
        ArrayList labelList = new ArrayList(this.field_146293_o);
        ArrayList infoRegions = new ArrayList(this.infoRegions);
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        this.infoRegions.clear();
        super.func_73863_a(par1, par2, par3);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        for (k = 0; k < buttonList.size(); ++k) {
            ((GuiButton)buttonList.get(k)).func_191745_a(this.field_146297_k, par1, par2, par3);
        }
        for (k = 0; k < labelList.size(); ++k) {
            ((GuiLabel)labelList.get(k)).func_146159_a(this.field_146297_k, par1, par2);
        }
        for (k = 0; k < infoRegions.size(); ++k) {
            ((GuiElementInfoRegion)infoRegions.get(k)).drawRegion(par1, par2);
        }
        this.field_146292_n = buttonList;
        this.field_146293_o = labelList;
        this.infoRegions = infoRegions;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        if (Math.random() < 0.025 && !this.destinationFrequency.isTextFocused) {
            if (!PlayerUtil.getName((EntityPlayer)this.field_146297_k.field_71439_g).equals(this.launchController.getOwnerName()) && !this.launchController.getDisabled(2)) {
                Random r = new Random();
                String fakefrequency = "";
                for (int i = 0; i < this.destinationFrequency.getMaxLength(); ++i) {
                    fakefrequency = fakefrequency + (char)(r.nextInt(93) + 33);
                }
                this.destinationFrequency.text = fakefrequency;
            } else {
                this.destinationFrequency.text = String.valueOf(this.launchController.destFrequency);
            }
        }
    }

    protected void func_73869_a(char keyChar, int keyID) throws IOException {
        if (keyID != 1 && keyID != this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            if (this.frequency.keyTyped(keyChar, keyID)) {
                return;
            }
            if (this.destinationFrequency.keyTyped(keyChar, keyID)) {
                return;
            }
        }
        super.func_73869_a(keyChar, keyID);
    }

    public boolean isValid(String string) {
        if (string.length() > 0 && ChatAllowedCharacters.func_71566_a((char)string.charAt(string.length() - 1))) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int xLeft = (this.field_146294_l - this.field_146999_f) / 2;
        int yTop = (this.field_146295_m - this.field_147000_g) / 2;
        this.enableControllerButton = new GuiButton(0, xLeft + 70 + 124 - 72, yTop + 16, 48, 20, GCCoreUtil.translate((String)"gui.button.enable.name"));
        this.frequency = new GuiElementTextBox(4, (GuiElementTextBox.ITextBoxCallback)this, xLeft + 66, yTop + 16, 48, 20, "", true, 6, false);
        this.destinationFrequency = new GuiElementTextBox(5, (GuiElementTextBox.ITextBoxCallback)this, xLeft + 45, yTop + 16 + 22, 48, 20, "", true, 6, false);
        this.hideDestinationFrequency = new GuiButton(6, xLeft + 95, yTop + 16 + 22, 39, 20, GCCoreUtil.translate((String)"gui.button.hide_dest.name"));
        this.openAdvancedConfig = new GuiButton(7, xLeft + 48, yTop + 62, 80, 20, GCCoreUtil.translate((String)"gui.launch_controller.advanced") + "...");
        this.field_146292_n.add(this.enableControllerButton);
        this.field_146292_n.add(this.frequency);
        this.field_146292_n.add(this.destinationFrequency);
        this.field_146292_n.add(this.hideDestinationFrequency);
        this.field_146292_n.add(this.openAdvancedConfig);
        this.electricInfoRegion.tooltipStrings = new ArrayList();
        this.electricInfoRegion.xPosition = xLeft + 98;
        this.electricInfoRegion.yPosition = yTop + 113;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion(xLeft + 151, yTop + 104, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        batterySlotDesc = new ArrayList();
        batterySlotDesc.addAll(GCCoreUtil.translateWithSplit((String)"gui.launch_controller.desc.0"));
        this.infoRegions.add(new GuiElementInfoRegion(xLeft + 5, yTop + 20, 109, 13, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        batterySlotDesc = new ArrayList();
        batterySlotDesc.addAll(GCCoreUtil.translateWithSplit((String)"gui.launch_controller.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion(xLeft + 5, yTop + 42, 87, 13, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        batterySlotDesc = new ArrayList();
        batterySlotDesc.addAll(GCCoreUtil.translateWithSplit((String)"gui.launch_controller.desc.4"));
        this.infoRegions.add(new GuiElementInfoRegion(xLeft + 95, yTop + 38, 38, 20, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
    }

    protected void func_73864_a(int px, int py, int par3) throws IOException {
        super.func_73864_a(px, py, par3);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (!PlayerUtil.getName((EntityPlayer)this.field_146297_k.field_71439_g).equals(this.launchController.getOwnerName())) {
            this.cannotEditTimer = 50;
            return;
        }
        if (par1GuiButton.field_146124_l) {
            switch (par1GuiButton.field_146127_k) {
                case 0: {
                    GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, this.field_146297_k.field_71441_e.field_73011_w.getDimension(), new Object[]{this.launchController.func_174877_v(), 0}));
                    break;
                }
                case 6: {
                    GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, this.field_146297_k.field_71441_e.field_73011_w.getDimension(), new Object[]{this.launchController.func_174877_v(), 2}));
                    break;
                }
                case 7: {
                    GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMars(PacketSimpleMars.EnumSimplePacketMars.S_SWITCH_LAUNCH_CONTROLLER_GUI, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.launchController.func_174877_v(), 0}));
                    break;
                }
            }
        }
    }

    protected void func_146979_b(int par1, int par2) {
        String displayString = this.launchController.getOwnerName() + "'s " + this.launchController.func_70005_c_();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 5, 0x404040);
        if (this.cannotEditTimer > 0) {
            this.field_146289_q.func_78276_b(this.launchController.getOwnerName(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 5, this.cannotEditTimer % 30 < 15 ? ColorUtil.to32BitColor((int)255, (int)255, (int)100, (int)100) : 0x404040);
            --this.cannotEditTimer;
        }
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"container.inventory"), 8, 115, 0x404040);
        displayString = this.getStatus();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 86, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"gui.message.frequency.name") + ":", 7, 22, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"gui.message.dest_frequency.name") + ":", 7, 44, 0x404040);
    }

    private String getStatus() {
        if (!this.launchController.frequencyValid) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.message.invalid_freq.name");
        }
        if (this.launchController.getEnergyStoredGC() <= 0.0f) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.message.no_energy.name");
        }
        if (this.launchController.getDisabled(0)) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        return EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.status.active.name");
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(launchControllerGui);
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var5, var6, 0, 0, this.field_146999_f, this.field_147000_g);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.launchController.getEnergyStoredGC(), (float)this.launchController.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.launchController.getEnergyStoredGC() > 0.0f) {
            int scale = this.launchController.getScaledElecticalLevel(54);
            this.func_73729_b(var5 + 99, var6 + 114, 176, 0, Math.min(scale, 54), 7);
        }
        GL11.glPopMatrix();
    }

    public boolean canPlayerEdit(GuiElementTextBox textBox, EntityPlayer player) {
        return PlayerUtil.getName((EntityPlayer)player).equals(this.launchController.getOwnerName());
    }

    public void onTextChanged(GuiElementTextBox textBox, String newText) {
        if (PlayerUtil.getName((EntityPlayer)this.field_146297_k.field_71439_g).equals(this.launchController.getOwnerName())) {
            if (textBox.equals(this.frequency)) {
                this.launchController.frequency = textBox.getIntegerValue();
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMars(PacketSimpleMars.EnumSimplePacketMars.S_UPDATE_ADVANCED_GUI, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{0, this.launchController.func_174877_v(), this.launchController.frequency}));
            } else if (textBox.equals(this.destinationFrequency)) {
                this.launchController.destFrequency = textBox.getIntegerValue();
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMars(PacketSimpleMars.EnumSimplePacketMars.S_UPDATE_ADVANCED_GUI, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{2, this.launchController.func_174877_v(), this.launchController.destFrequency}));
            }
        }
    }

    public String getInitialText(GuiElementTextBox textBox) {
        if (textBox.equals(this.frequency)) {
            return String.valueOf(this.launchController.frequency);
        }
        if (textBox.equals(this.destinationFrequency)) {
            if (PlayerUtil.getName((EntityPlayer)this.field_146297_k.field_71439_g).equals(this.launchController.getOwnerName()) || this.launchController.getDisabled(2)) {
                return String.valueOf(this.launchController.destFrequency);
            }
            Random r = new Random();
            String fakefrequency = "";
            for (int i = 0; i < this.destinationFrequency.getMaxLength(); ++i) {
                fakefrequency = fakefrequency + (char)(r.nextInt(93) + 33);
            }
            return fakefrequency;
        }
        return "";
    }

    public int getTextColor(GuiElementTextBox textBox) {
        if (textBox.equals(this.frequency)) {
            return this.launchController.frequencyValid ? ColorUtil.to32BitColor((int)255, (int)20, (int)255, (int)20) : ColorUtil.to32BitColor((int)255, (int)255, (int)25, (int)25);
        }
        if (textBox.equals(this.destinationFrequency)) {
            return this.launchController.destFrequencyValid ? ColorUtil.to32BitColor((int)255, (int)20, (int)255, (int)20) : ColorUtil.to32BitColor((int)255, (int)255, (int)25, (int)25);
        }
        return 0;
    }

    public void onIntruderInteraction(GuiElementTextBox textBox) {
        this.cannotEditTimer = 50;
    }
}

