/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.items;

import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.item.IHoldableItem;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.ISortableItem;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPadSingle;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryItem;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityTier3Rocket;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTier3Rocket
extends Item
implements IHoldableItem,
ISortableItem {
    public ItemTier3Rocket(String assetName) {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b(assetName);
    }

    public static boolean placeRocketOnPad(ItemStack stack, World worldIn, TileEntity tile, float centerX, float centerY, float centerZ) {
        if (tile instanceof TileEntityLandingPad) {
            if (((TileEntityLandingPad)tile).getDockedEntity() != null) {
                return false;
            }
        } else {
            return false;
        }
        EntityTier3Rocket rocket = new EntityTier3Rocket(worldIn, centerX, centerY, centerZ, IRocketType.EnumRocketType.values()[stack.func_77952_i()]);
        rocket.field_70177_z += 45.0f;
        rocket.func_70107_b(rocket.field_70165_t, rocket.field_70163_u + rocket.getOnPadYOffset(), rocket.field_70161_v);
        worldIn.func_72838_d((Entity)rocket);
        if (rocket.getType().getPreFueled()) {
            rocket.fuelTank.fill(new FluidStack(GCFluids.fluidFuel, rocket.getMaxFuel()), true);
        } else if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("RocketFuel")) {
            rocket.fuelTank.fill(new FluidStack(GCFluids.fluidFuel, stack.func_77978_p().func_74762_e("RocketFuel")), true);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return GalacticraftCore.galacticraftItemsTab;
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean padFound = false;
        TileEntity tile = null;
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        float centerX = (float)pos.func_177958_n() + 0.5f;
        float centerY = (float)pos.func_177956_o() + 0.4f;
        float centerZ = (float)pos.func_177952_p() + 0.5f;
        if (!worldIn.func_180495_p(pos).toString().equals("galacticraftcore:landing_pad_full[type=rocket]") && !worldIn.func_180495_p(pos).toString().equals("galacticraftcore:block_multi[rendertype=0,type=rocket_pad]")) {
            BlockPos newPos;
            int j;
            int i;
            pos = pos.func_177982_a(0, 1, 0);
            centerY += 1.0f;
            for (i = -1; i < 2; ++i) {
                for (j = -1; j < 2; ++j) {
                    newPos = pos.func_177982_a(i, 0, j);
                    if (worldIn.func_175623_d(newPos)) continue;
                    playerIn.func_146105_b(new TextComponentString("3x3 space not clear for Launch pad.").func_150255_a(new Style().func_150227_a(Boolean.valueOf(true))), true);
                    return EnumActionResult.FAIL;
                }
            }
            for (i = -1; i < 2; ++i) {
                for (j = -1; j < 2; ++j) {
                    newPos = pos.func_177982_a(i, 0, j);
                    worldIn.func_180501_a(newPos, GCBlocks.landingPad.func_176203_a(0), 3);
                    worldIn.func_180495_p(newPos).func_177230_c().func_176213_c(worldIn, newPos, GCBlocks.landingPad.func_176203_a(0));
                }
            }
            ((TileEntityLandingPadSingle)worldIn.func_175625_s(pos)).func_73660_a();
        } else {
            block4: for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    BlockPos newPos = pos.func_177982_a(i, 0, j);
                    IBlockState state = worldIn.func_180495_p(newPos);
                    Block id = state.func_177230_c();
                    if (id != GCBlocks.landingPadFull) continue;
                    centerX += (float)i;
                    centerZ += (float)j;
                    continue block4;
                }
            }
        }
        tile = worldIn.func_175625_s(pos);
        if (!ItemTier3Rocket.placeRocketOnPad(stack, worldIn, tile, centerX, centerY, centerZ)) {
            return EnumActionResult.FAIL;
        }
        if (!playerIn.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == GalacticraftCore.galacticraftItemsTab || tab == CreativeTabs.field_78027_g) {
            for (int i = 0; i < IRocketType.EnumRocketType.values().length; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        IRocketType.EnumRocketType type = par1ItemStack.func_77952_i() < 10 ? IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i()] : IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i() - 10];
        if (!type.getTooltip().isEmpty()) {
            tooltip.add(type.getTooltip());
        }
        if (type.getPreFueled()) {
            tooltip.add(EnumColor.RED + "\u00a7o" + GCCoreUtil.translate((String)"gui.creative_only.desc"));
        }
        if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("RocketFuel")) {
            EntityTier3Rocket rocket = new EntityTier3Rocket((World)FMLClientHandler.instance().getWorldClient(), 0.0, 0.0, 0.0, IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i()]);
            tooltip.add(GCCoreUtil.translate((String)"gui.message.fuel.name") + ": " + par1ItemStack.func_77978_p().func_74762_e("RocketFuel") + " / " + rocket.fuelTank.getCapacity());
        }
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return super.func_77667_c(par1ItemStack) + ".t3Rocket";
    }

    public boolean shouldHoldLeftHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldHoldRightHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldCrouch(EntityPlayer player) {
        return true;
    }

    public EnumSortCategoryItem getCategory(int meta) {
        return EnumSortCategoryItem.ROCKET;
    }
}

