/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.items;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.item.IItemOxygenSupply;
import micdoodle8.mods.galacticraft.core.items.ISortableItem;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryItem;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCanisterLiquidOxygen
extends ItemCanisterGeneric
implements IItemOxygenSupply,
ISortableItem {
    private static final HashMap<ItemStack, Integer> craftingvalues = new HashMap();

    public ItemCanisterLiquidOxygen(String assetName) {
        super(assetName);
        this.setAllowedFluid("liquidoxygen");
    }

    public static void saveDamage(ItemStack itemstack, int damage) {
        craftingvalues.put(itemstack, damage);
    }

    public String func_77667_c(ItemStack itemStack) {
        if (1001 - itemStack.func_77952_i() == 0) {
            return "item.empty_gas_canister";
        }
        if (itemStack.func_77952_i() == 1) {
            return "item.canister.lox.full";
        }
        return "item.canister.lox.partial";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (1001 - par1ItemStack.func_77952_i() > 0) {
            tooltip.add(GCCoreUtil.translate((String)"item.canister.lox.name") + ": " + (1001 - par1ItemStack.func_77952_i()));
        }
    }

    public ItemStack getContainerItem(ItemStack itemstack) {
        Integer saved = craftingvalues.get(itemstack);
        if (saved != null) {
            if (saved < 1001) {
                craftingvalues.remove(itemstack);
                itemstack.func_77964_b(saved.intValue());
                return itemstack.func_77946_l();
            }
            return new ItemStack(this.func_77668_q(), 1, 1001);
        }
        if (GCCoreUtil.getEffectiveSide() == Side.CLIENT) {
            return itemstack.func_77946_l();
        }
        return super.getContainerItem(itemstack);
    }

    public int discharge(ItemStack itemStack, int amount) {
        int damage = itemStack.func_77952_i();
        int used = Math.min((int)((float)amount * 0.09259259f), 1001 - damage);
        this.setNewDamage(itemStack, damage + used);
        return (int)Math.floor((float)used / 0.09259259f);
    }

    public int getOxygenStored(ItemStack par1ItemStack) {
        return 1001 - par1ItemStack.func_77952_i();
    }

    public EnumSortCategoryItem getCategory(int meta) {
        return EnumSortCategoryItem.CANISTER;
    }
}

