/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids;

import java.io.File;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class ConfigManagerAsteroids {
    public static boolean loaded;
    public static int dimensionIDAsteroids;
    public static int idSchematicRocketT3;
    public static boolean disableGalacticraftHelium;
    public static int astroMinerMax;
    public static boolean disableIlmeniteGen;
    public static boolean disableIronGen;
    public static boolean disableAluminumGen;
    static Configuration config;

    public ConfigManagerAsteroids(File file) {
        if (!loaded) {
            if (file.exists()) {
                config = new Configuration(file);
                ConfigManagerAsteroids.syncConfig(true, true);
                file.delete();
                config = ConfigManagerMars.config;
            } else {
                config = ConfigManagerMars.config;
                ConfigManagerAsteroids.syncConfig(true, false);
            }
        }
    }

    public static void syncConfig(boolean load, boolean update) {
        try {
            Property propCopy;
            if (!ConfigManagerAsteroids.config.isChild && update) {
                config.load();
            }
            Property prop = config.get("dimensions", "dimensionIDAsteroids", -30);
            prop.setComment("Dimension ID for Asteroids");
            prop.setLanguageKey("gc.configgui.dimension_id_asteroids").setRequiresMcRestart(true);
            if (update) {
                propCopy = ConfigManagerMars.config.get("dimensions", prop.getName(), prop.getInt(), prop.getComment());
                propCopy.setLanguageKey(prop.getLanguageKey());
                propCopy.setRequiresMcRestart(prop.requiresMcRestart());
            }
            dimensionIDAsteroids = prop.getInt();
            GalacticraftPlanets.finishProp(prop, "dimensions");
            prop = config.get("schematic", "idSchematicRocketT3", 4);
            prop.setComment("Schematic ID for Tier 3 Rocket, must be unique.");
            prop.setLanguageKey("gc.configgui.id_schematic_rocket_t3");
            if (update) {
                propCopy = ConfigManagerMars.config.get("schematic", prop.getName(), prop.getInt(), prop.getComment());
                propCopy.setLanguageKey(prop.getLanguageKey());
            }
            idSchematicRocketT3 = prop.getInt(4);
            GalacticraftPlanets.finishProp(prop, "schematic");
            prop = config.get("general", "disableGalacticraftHelium", false);
            prop.setComment("Option to disable Helium gas in Galacticraft (because it will be registered by another mod eg GregTech).");
            prop.setLanguageKey("gc.configgui.disable_galacticraft_helium");
            if (update) {
                propCopy = ConfigManagerMars.config.get("general", prop.getName(), prop.getBoolean(), prop.getComment());
                propCopy.setLanguageKey(prop.getLanguageKey());
            }
            disableGalacticraftHelium = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "general");
            prop = config.get("general", "maximumAstroMiners", 6);
            prop.setComment("Maximum number of Astro Miners each player is allowed to have active (default 6).");
            prop.setLanguageKey("gc.configgui.astro_miners_max");
            if (update) {
                propCopy = ConfigManagerMars.config.get("general", prop.getName(), prop.getInt(), prop.getComment());
                propCopy.setLanguageKey(prop.getLanguageKey());
            }
            astroMinerMax = prop.getInt(6);
            GalacticraftPlanets.finishProp(prop, "general");
            prop = config.get(update ? "general" : "worldgen", "Disable Iron Ore Gen on Asteroids", false);
            prop.setComment("Disable Iron Ore Gen on Asteroids.");
            prop.setLanguageKey("gc.configgui.disable_iron_gen_asteroids");
            if (update) {
                propCopy = ConfigManagerMars.config.get("worldgen", prop.getName(), prop.getBoolean(), prop.getComment());
                propCopy.setLanguageKey(prop.getLanguageKey());
            }
            disableIronGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
            prop = config.get(update ? "general" : "worldgen", "Disable Aluminum Ore Gen on Asteroids", false);
            prop.setComment("Disable Aluminum Ore Gen on Asteroids.");
            prop.setLanguageKey("gc.configgui.disable_aluminum_gen_asteroids");
            if (update) {
                propCopy = ConfigManagerMars.config.get("worldgen", prop.getName(), prop.getBoolean(), prop.getComment());
                propCopy.setLanguageKey(prop.getLanguageKey());
            }
            disableAluminumGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
            prop = config.get(update ? "general" : "worldgen", "Disable Ilmenite Ore Gen on Asteroids", false);
            prop.setComment("Disable Ilmenite Ore Gen on Asteroids.");
            prop.setLanguageKey("gc.configgui.disable_ilmenite_gen_asteroids");
            if (update) {
                propCopy = ConfigManagerMars.config.get("worldgen", prop.getName(), prop.getBoolean(), prop.getComment());
                propCopy.setLanguageKey(prop.getLanguageKey());
            }
            disableIlmeniteGen = prop.getBoolean(false);
            GalacticraftPlanets.finishProp(prop, "worldgen");
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Galacticraft Asteroids (Planets) has a problem loading its config", (Object[])new Object[0]);
        }
    }
}

