/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackValidatedNBT;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CompactorManager {
    private static Map<ComparableItemStackValidatedNBT, CompactorRecipe> recipeMapAll = new Object2ObjectOpenHashMap();
    private static Map<ComparableItemStackValidatedNBT, CompactorRecipe> recipeMapPlate = new Object2ObjectOpenHashMap();
    private static Map<ComparableItemStackValidatedNBT, CompactorRecipe> recipeMapCoin = new Object2ObjectOpenHashMap();
    private static Map<ComparableItemStackValidatedNBT, CompactorRecipe> recipeMapGear = new Object2ObjectOpenHashMap();
    private static Set<ComparableItemStackValidatedNBT> validationSet = new ObjectOpenHashSet();
    public static final int DEFAULT_ENERGY = 20000;

    public static CompactorRecipe getRecipe(ItemStack input, Mode mode) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackValidatedNBT query = new ComparableItemStackValidatedNBT(input);
        CompactorRecipe recipe = null;
        switch (mode) {
            case PLATE: {
                recipe = recipeMapPlate.get(query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapPlate.get(query);
                break;
            }
            case COIN: {
                recipe = recipeMapCoin.get(query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapCoin.get(query);
                break;
            }
            case GEAR: {
                recipe = recipeMapGear.get(query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapGear.get(query);
            }
        }
        if (recipe == null) {
            return recipeMapAll.get(query);
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input, Mode mode) {
        return CompactorManager.getRecipe(input, mode) != null;
    }

    public static CompactorRecipe[] getRecipeList(Mode mode) {
        switch (mode) {
            case PLATE: {
                return recipeMapPlate.values().toArray(new CompactorRecipe[0]);
            }
            case COIN: {
                return recipeMapCoin.values().toArray(new CompactorRecipe[0]);
            }
            case GEAR: {
                return recipeMapGear.values().toArray(new CompactorRecipe[0]);
            }
        }
        return recipeMapAll.values().toArray(new CompactorRecipe[0]);
    }

    public static boolean isItemValid(ItemStack input) {
        return !input.func_190926_b() && validationSet.contains(new ComparableItemStackValidatedNBT(input));
    }

    public static void initialize() {
        String[] oreNames;
        for (String oreName : oreNames = OreDictionary.getOreNames()) {
            String oreType;
            if (oreName.startsWith("plate")) {
                oreType = oreName.substring(5);
                CompactorManager.addDefaultPlateRecipe(oreType);
                continue;
            }
            if (oreName.startsWith("gear")) {
                oreType = oreName.substring(4);
                CompactorManager.addDefaultGearRecipe(oreType);
                continue;
            }
            if (!oreName.startsWith("coin")) continue;
            oreType = oreName.substring(4);
            CompactorManager.addDefaultCoinRecipe(oreType);
        }
    }

    public static void refresh() {
        ComparableItemStackValidatedNBT input;
        CompactorRecipe tempRecipe;
        Object2ObjectOpenHashMap tempAll = new Object2ObjectOpenHashMap(recipeMapAll.size());
        Object2ObjectOpenHashMap tempPlate = new Object2ObjectOpenHashMap(recipeMapPlate.size());
        Object2ObjectOpenHashMap tempMint = new Object2ObjectOpenHashMap(recipeMapCoin.size());
        Object2ObjectOpenHashMap tempGear = new Object2ObjectOpenHashMap(recipeMapGear.size());
        ObjectOpenHashSet tempSet = new ObjectOpenHashSet();
        for (Map.Entry<ComparableItemStackValidatedNBT, CompactorRecipe> entry : recipeMapAll.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackValidatedNBT(tempRecipe.input);
            tempPlate.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<ComparableItemStackValidatedNBT, CompactorRecipe> entry : recipeMapPlate.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackValidatedNBT(tempRecipe.input);
            tempPlate.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<ComparableItemStackValidatedNBT, CompactorRecipe> entry : recipeMapCoin.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackValidatedNBT(tempRecipe.input);
            tempMint.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<ComparableItemStackValidatedNBT, CompactorRecipe> entry : recipeMapGear.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackValidatedNBT(tempRecipe.input);
            tempGear.put(input, tempRecipe);
            tempSet.add(input);
        }
        recipeMapAll.clear();
        recipeMapPlate.clear();
        recipeMapCoin.clear();
        recipeMapGear.clear();
        recipeMapAll = tempAll;
        recipeMapPlate = tempPlate;
        recipeMapCoin = tempMint;
        recipeMapGear = tempGear;
        validationSet.clear();
        validationSet = tempSet;
    }

    public static CompactorRecipe addRecipe(int energy, ItemStack input, ItemStack output, Mode mode) {
        if (input.func_190926_b() || output.func_190926_b() || energy <= 0 || CompactorManager.recipeExists(input, mode)) {
            return null;
        }
        CompactorRecipe recipe = new CompactorRecipe(input, output, energy);
        switch (mode) {
            case ALL: {
                recipeMapAll.put(new ComparableItemStackValidatedNBT(input), recipe);
            }
        }
        validationSet.add(new ComparableItemStackValidatedNBT(input));
        return recipe;
    }

    public static CompactorRecipe removeRecipe(ItemStack input, Mode mode) {
        switch (mode) {
            case ALL: {
                return recipeMapAll.remove(new ComparableItemStackValidatedNBT(input));
            }
            case PLATE: {
                return recipeMapPlate.remove(new ComparableItemStackValidatedNBT(input));
            }
            case COIN: {
                return recipeMapCoin.remove(new ComparableItemStackValidatedNBT(input));
            }
        }
        return recipeMapGear.remove(new ComparableItemStackValidatedNBT(input));
    }

    public static ComparableItemStackValidatedNBT convertInput(ItemStack stack) {
        return new ComparableItemStackValidatedNBT(stack);
    }

    private static void addDefaultPlateRecipe(String oreType) {
    }

    private static void addDefaultPlateRecipe(String oreType, ItemStack plate) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        CompactorManager.addRecipe(20000, ItemHelper.getOre((String)("ingot" + StringHelper.titleCase((String)oreType))), ItemHelper.cloneStack((ItemStack)plate, (int)1), Mode.PLATE);
        CompactorManager.addRecipe(20000, ItemHelper.getOre((String)("gem" + StringHelper.titleCase((String)oreType))), ItemHelper.cloneStack((ItemStack)plate, (int)1), Mode.PLATE);
    }

    private static void addDefaultGearRecipe(String oreType) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String gearName = "gear" + StringHelper.titleCase((String)oreType);
        if (!ItemHelper.oreNameExists((String)gearName)) {
            return;
        }
        CompactorManager.addDefaultGearRecipe(oreType, ItemHelper.getOre((String)gearName));
    }

    private static void addDefaultGearRecipe(String oreType, ItemStack gear) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
    }

    private static void addDefaultCoinRecipe(String oreType) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String coinName = "coin" + StringHelper.titleCase((String)oreType);
        if (!ItemHelper.oreNameExists((String)coinName)) {
            return;
        }
        CompactorManager.addDefaultCoinRecipe(oreType, ItemHelper.getOre((String)coinName));
    }

    private static void addDefaultCoinRecipe(String oreType, ItemStack coin) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        CompactorManager.addRecipe(20000, ItemHelper.getOre((String)("ingot" + StringHelper.titleCase((String)oreType))), ItemHelper.cloneStack((ItemStack)coin, (int)3), Mode.COIN);
    }

    public static enum Mode {
        ALL,
        PLATE,
        COIN,
        GEAR;

    }

    public static class CompactorRecipe {
        final ItemStack input;
        final ItemStack output;
        final int energy;

        CompactorRecipe(ItemStack input, ItemStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

