/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiRefinery;
import cofh.thermalexpansion.gui.container.machine.ContainerRefinery;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileRefinery
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.REFINERY.getMetadata();
    public static int basePower = 20;
    public static final int SPEC_ENERGY_MOD = 100;
    public static final int SPEC_FLUID_BOOST = 50;
    private RefineryManager.RefineryRecipe curRecipe;
    private int outputTracker;
    private int outputTrackerFluid;
    private FluidTankCore inputTank = new FluidTankCore(8000);
    private FluidTankCore outputTank = new FluidTankCore(32000);
    private FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 0);
    protected boolean augmentFossil;
    protected boolean augmentBio;
    protected boolean augmentPotion;

    public static void initialize() {
        TileRefinery.SIDE_CONFIGS[TileRefinery.TYPE] = new SideConfig();
        TileRefinery.SIDE_CONFIGS[TileRefinery.TYPE].numConfig = 7;
        TileRefinery.SIDE_CONFIGS[TileRefinery.TYPE].slotGroups = new int[][]{new int[0], new int[0], new int[0], {0}, {0}, {0}, {0}};
        TileRefinery.SIDE_CONFIGS[TileRefinery.TYPE].sideTypes = new int[]{0, 1, 2, 3, 4, 7, 8};
        TileRefinery.SIDE_CONFIGS[TileRefinery.TYPE].defaultSides = new byte[]{1, 2, 3, 3, 3, 3};
        TileRefinery.ALT_SIDE_CONFIGS[TileRefinery.TYPE] = new SideConfig();
        TileRefinery.ALT_SIDE_CONFIGS[TileRefinery.TYPE].numConfig = 2;
        TileRefinery.ALT_SIDE_CONFIGS[TileRefinery.TYPE].slotGroups = new int[][]{new int[0], new int[0], new int[0], {0}, {0}, {0}, {0}};
        TileRefinery.ALT_SIDE_CONFIGS[TileRefinery.TYPE].sideTypes = new int[]{0, 7};
        TileRefinery.ALT_SIDE_CONFIGS[TileRefinery.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileRefinery.SLOT_CONFIGS[TileRefinery.TYPE] = new SlotConfig();
        TileRefinery.SLOT_CONFIGS[TileRefinery.TYPE].allowInsertionSlot = new boolean[]{false, false};
        TileRefinery.VALID_AUGMENTS[TileRefinery.TYPE] = new HashSet();
        TileRefinery.SLOT_CONFIGS[TileRefinery.TYPE].allowExtractionSlot = new boolean[]{true, false};
        VALID_AUGMENTS[TYPE].add("machineRefineryFossil");
        VALID_AUGMENTS[TYPE].add("machineRefineryPotion");
        VALID_AUGMENTS[TYPE].add("machineSecondary");
        VALID_AUGMENTS[TYPE].add("machineSecondaryNull");
        GameRegistry.registerTileEntity(TileRefinery.class, (String)"thermalexpansion:machine_refinery");
        TileRefinery.config();
    }

    public static void config() {
        String category = "Machine.Refinery";
        BlockMachine.enable[TileRefinery.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Fractionating Still. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 5000, comment);
        TileRefinery.ENERGY_CONFIGS[TileRefinery.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileRefinery() {
        this.inventory = new ItemStack[2];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public int getLightValue() {
        return this.isActive ? this.renderFluid.getFluid().getLuminosity(this.renderFluid) : 0;
    }

    @Override
    protected int getMaxInputSlot() {
        return -1;
    }

    @Override
    protected boolean canStart() {
        if (this.energyStorage.getEnergyStored() <= 0 || this.outputTank.getSpace() <= 0) {
            return false;
        }
        this.getRecipe();
        if (this.curRecipe == null) {
            return false;
        }
        if (this.inputTank.getFluidAmount() < this.curRecipe.getInput().amount) {
            return false;
        }
        FluidStack outputFluid = this.curRecipe.getOutputFluid();
        ItemStack outputItem = this.curRecipe.getOutputItem();
        if (!(outputItem.func_190926_b() || this.inventory[0].func_190926_b() || this.augmentSecondaryNull)) {
            if (!this.inventory[0].func_77969_a(outputItem)) {
                return false;
            }
            if (this.inventory[0].func_190916_E() + outputItem.func_190916_E() > outputItem.func_77976_d()) {
                return false;
            }
        }
        return this.outputTank.fill(outputFluid, false) == outputFluid.amount;
    }

    @Override
    protected boolean hasValidInput() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        return this.curRecipe != null;
    }

    @Override
    protected void clearRecipe() {
        this.curRecipe = null;
    }

    @Override
    protected void getRecipe() {
        this.curRecipe = this.augmentPotion ? RefineryManager.getRecipePotion(this.inputTank.getFluid()) : RefineryManager.getRecipe(this.inputTank.getFluid());
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = this.curRecipe.getEnergy() * this.energyMod / 100;
        FluidStack prevStack = this.renderFluid.copy();
        this.renderFluid = this.inputTank.getFluid().copy();
        this.renderFluid.amount = 0;
        if (!FluidHelper.isFluidEqual((FluidStack)prevStack, (FluidStack)this.renderFluid)) {
            this.sendFluidPacket();
        }
    }

    @Override
    protected void processFinish() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            this.processOff();
            return;
        }
        if (this.augmentFossil && RefineryManager.isFossilFuel(this.curRecipe.getInput()) || this.augmentBio && RefineryManager.isBioFuel(this.curRecipe.getInput())) {
            this.outputTank.fill(new FluidStack(this.curRecipe.getOutputFluid(), this.curRecipe.getOutputFluid().amount + 50), true);
        } else {
            this.outputTank.fill(this.curRecipe.getOutputFluid(), true);
        }
        ItemStack outputItem = this.curRecipe.getOutputItem();
        if (!outputItem.func_190926_b()) {
            int modifiedChance = this.secondaryChance;
            int recipeChance = this.curRecipe.getChance();
            if (recipeChance >= 100 || this.field_145850_b.field_73012_v.nextInt(modifiedChance) < recipeChance) {
                if (this.inventory[0].func_190926_b()) {
                    this.inventory[0] = ItemHelper.cloneStack((ItemStack)outputItem);
                    if (recipeChance > modifiedChance && this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                        this.inventory[0].func_190917_f(outputItem.func_190916_E());
                    }
                } else if (ItemHelper.itemsIdentical((ItemStack)this.inventory[0], (ItemStack)outputItem)) {
                    this.inventory[0].func_190917_f(outputItem.func_190916_E());
                    if (recipeChance > modifiedChance && this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                        this.inventory[0].func_190917_f(outputItem.func_190916_E());
                    }
                }
                if (this.inventory[0].func_190916_E() > this.inventory[0].func_77976_d()) {
                    this.inventory[0].func_190920_e(this.inventory[0].func_77976_d());
                }
            }
        }
        this.inputTank.drain(this.curRecipe.getInput().amount, true);
    }

    @Override
    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        this.transferOutputFluid();
        if (this.inventory[0].func_190926_b()) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isSecondaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    private void transferOutputFluid() {
        if (!this.getTransferOut()) {
            return;
        }
        if (this.outputTank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.outputTank.getFluid(), Math.min(this.outputTank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.outputTank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    @Override
    public void func_73660_a() {
        if (this.timeCheckEighth()) {
            this.transferOutputFluid();
        }
        super.func_73660_a();
    }

    @Override
    protected void setLevelFlags() {
        super.setLevelFlags();
        this.hasAutoInput = false;
        this.enableAutoInput = false;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiRefinery(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerRefinery(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank(int tankIndex) {
        if (tankIndex == 0) {
            return this.inputTank;
        }
        return this.outputTank;
    }

    public FluidStack getTankFluid(int tankIndex) {
        if (tankIndex == 0) {
            return this.inputTank.getFluid();
        }
        return this.outputTank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOut2");
        this.inputTank.readFromNBT(nbt.func_74775_l("TankIn"));
        this.outputTank.readFromNBT(nbt.func_74775_l("TankOut"));
        if (this.inputTank.getFluid() != null) {
            this.renderFluid = this.inputTank.getFluid().copy();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74768_a("TrackOut2", this.outputTrackerFluid);
        nbt.func_74782_a("TankIn", (NBTBase)this.inputTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("TankOut", (NBTBase)this.outputTank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        if (this.inputTank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.inputTank.getFluid());
        }
        payload.addFluidStack(this.outputTank.getFluid());
        return payload;
    }

    public PacketBase getFluidPacket() {
        PacketBase payload = super.getFluidPacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.inputTank.setFluid(payload.getFluidStack());
        this.outputTank.setFluid(payload.getFluidStack());
    }

    protected void handleFluidPacket(PacketBase payload) {
        super.handleFluidPacket(payload);
        this.renderFluid = payload.getFluidStack();
        this.callBlockUpdate();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.renderFluid = payload.getFluidStack();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentFossil = false;
        this.augmentBio = false;
        this.augmentPotion = false;
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentFossil && "machineRefineryFossil".equals(id)) {
            this.augmentFossil = true;
            this.hasModeAugment = true;
            this.energyMod += 100;
            return true;
        }
        if (!this.augmentBio && "machineRefineryBio".equals(id)) {
            this.augmentBio = true;
            this.hasModeAugment = true;
            this.energyMod += 100;
            return true;
        }
        if (!this.augmentPotion && "machineRefineryPotion".equals(id)) {
            this.augmentPotion = true;
            this.hasModeAugment = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.MACHINE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.MACHINE_TOP;
            }
            return side != this.facing ? TETextures.MACHINE_SIDE : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.renderFluid) : TETextures.MACHINE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.MACHINE_ACTIVE[TYPE] : TETextures.MACHINE_FACE[TYPE]);
        }
        return TETextures.MACHINE_SIDE;
    }

    @Override
    public boolean hasFluidUnderlay() {
        return true;
    }

    @Override
    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    @Override
    public int getColorMask(BlockRenderLayer layer, EnumFacing side) {
        return layer == BlockRenderLayer.SOLID && side.ordinal() == this.facing && this.isActive ? this.renderFluid.getFluid().getColor(this.renderFluid) << 8 | 0xFF : super.getColorMask(layer, side);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo inputInfo = TileRefinery.this.inputTank.getInfo();
                    FluidTankInfo outputInfo = TileRefinery.this.outputTank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(inputInfo.fluid, inputInfo.capacity, true, false), new FluidTankProperties(outputInfo.fluid, outputInfo.capacity, false, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from == null || SideConfig.allowInsertion((int)((TileRefinery)TileRefinery.this).sideConfig.sideTypes[TileRefinery.this.sideCache[from.ordinal()]])) {
                        if (TileRefinery.this.augmentPotion ? !RefineryManager.recipeExistsPotion(resource) : !RefineryManager.recipeExists(resource)) {
                            return 0;
                        }
                        return TileRefinery.this.inputTank.fill(resource, doFill);
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null) {
                        FluidStack ret = TileRefinery.this.outputTank.drain(resource, doDrain);
                        return ret != null ? ret : (TileRefinery.this.isActive ? null : TileRefinery.this.inputTank.drain(resource, doDrain));
                    }
                    int type = ((TileRefinery)TileRefinery.this).sideConfig.sideTypes[TileRefinery.this.sideCache[from.ordinal()]];
                    if (SideConfig.allowExtraction((int)type)) {
                        if (SideConfig.isPrimaryInput((int)type)) {
                            return TileRefinery.this.inputTank.drain(resource, doDrain);
                        }
                        if (SideConfig.isPrimaryOutput((int)type)) {
                            return TileRefinery.this.outputTank.drain(resource, doDrain);
                        }
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null) {
                        FluidStack ret = TileRefinery.this.outputTank.drain(maxDrain, doDrain);
                        return ret != null ? ret : (TileRefinery.this.isActive ? null : TileRefinery.this.inputTank.drain(maxDrain, doDrain));
                    }
                    int type = ((TileRefinery)TileRefinery.this).sideConfig.sideTypes[TileRefinery.this.sideCache[from.ordinal()]];
                    if (SideConfig.allowExtraction((int)type)) {
                        if (SideConfig.isPrimaryInput((int)type)) {
                            return TileRefinery.this.inputTank.drain(maxDrain, doDrain);
                        }
                        if (SideConfig.isPrimaryOutput((int)type)) {
                            return TileRefinery.this.outputTank.drain(maxDrain, doDrain);
                        }
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

