/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.api.core.IAccelerable;
import cofh.api.item.IAugmentItem;
import cofh.api.item.IUpgradeItem;
import cofh.core.block.TilePowered;
import cofh.core.init.CoreProps;
import cofh.core.network.PacketBase;
import cofh.core.util.TimeTracker;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.redstoneflux.impl.EnergyStorage;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileMachineBase
extends TilePowered
implements IAccelerable,
ITickable {
    public static final SideConfig[] SIDE_CONFIGS = new SideConfig[BlockMachine.Type.values().length];
    public static final SideConfig[] ALT_SIDE_CONFIGS = new SideConfig[BlockMachine.Type.values().length];
    public static final SlotConfig[] SLOT_CONFIGS = new SlotConfig[BlockMachine.Type.values().length];
    public static final EnergyConfig[] ENERGY_CONFIGS = new EnergyConfig[BlockMachine.Type.values().length];
    public static final HashSet<String>[] VALID_AUGMENTS = new HashSet[BlockMachine.Type.values().length];
    public static final int[] LIGHT_VALUES = new int[BlockMachine.Type.values().length];
    public static final int MIN_BASE_POWER = 10;
    public static final int MAX_BASE_POWER = 5000;
    public static int[] POWER_SCALING = new int[]{100, 150, 200, 250, 300};
    public static int[] ENERGY_SCALING = new int[]{100, 100, 100, 100, 100};
    public static byte[] NUM_AUGMENTS = new byte[]{0, 1, 2, 3, 4};
    protected static boolean enableCreative = false;
    protected static boolean enableSecurity = true;
    protected static boolean enableUpgrades = true;
    protected static boolean customAugmentScaling = false;
    protected static boolean customPowerScaling = false;
    protected static boolean customEnergyScaling = false;
    public static boolean disableAutoInput = false;
    public static boolean disableAutoOutput = false;
    public static boolean smallStorage = false;
    protected static final HashSet<String> VALID_AUGMENTS_BASE = new HashSet();
    protected static final int ENERGY_BASE = 100;
    protected static final int POWER_BASE = 100;
    protected static final int SECONDARY_BASE = 100;
    protected static final int SECONDARY_MIN = 5;
    protected static final int REUSE_BASE = 0;
    protected static final int REUSE_MAX = 95;
    int processMax;
    int processRem;
    boolean hasModeAugment;
    EnergyConfig energyConfig;
    TimeTracker tracker = new TimeTracker();
    int energyMod = 100;
    int secondaryChance = 100;
    int reuseChance = 0;
    protected boolean augmentSecondaryNull;

    public static void config() {
        int i;
        String category = "Machine";
        String comment = "If TRUE, Machines are securable.";
        enableSecurity = ThermalExpansion.CONFIG.get(category, "Securable", true, comment);
        comment = "If TRUE, Machines are upgradable. If disabled, be sure and change the Augment Scaling config options as well.";
        enableUpgrades = ThermalExpansion.CONFIG.get(category, "Upgradable", enableUpgrades, comment);
        comment = "If TRUE, 'Classic' Crafting is enabled - Non-Creative Upgrade Kits WILL NOT WORK in a Crafting Grid.";
        BlockMachine.enableClassicRecipes = ThermalExpansion.CONFIG.get(category, "ClassicCrafting", BlockMachine.enableClassicRecipes, comment);
        comment = "If TRUE, Machines can be upgraded in a Crafting Grid using Kits. If Classic Crafting is enabled, only the Creative Conversion Kit may be used in this fashion.";
        BlockMachine.enableUpgradeKitCrafting = ThermalExpansion.CONFIG.get(category, "UpgradeKitCrafting", BlockMachine.enableUpgradeKitCrafting, comment);
        comment = "If TRUE, Machine Augment Slot scaling will use a custom set of values rather than default behavior (1/level).";
        customAugmentScaling = ThermalExpansion.CONFIG.get(category, "CustomAugmentScaling", customAugmentScaling, comment);
        comment = "If TRUE, Machine RF/t (POWER) scaling will use a custom set of values rather than default behavior. The default custom configuration provides a reasonable alternate progression.";
        customPowerScaling = ThermalExpansion.CONFIG.get(category, "CustomPowerScaling", customPowerScaling, comment);
        comment = "If TRUE, Machine Total RF (ENERGY) scaling will use a custom set of values rather than default behavior (no scaling). The default custom configuration provides an alternate progression where machines use 5% additional total RF per tier.";
        customEnergyScaling = ThermalExpansion.CONFIG.get(category, "CustomEnergyScaling", customEnergyScaling, comment);
        comment = "If TRUE, Machines will no longer have Auto-Input functionality. Not recommended, but knock yourself out.";
        disableAutoInput = ThermalExpansion.CONFIG.get(category, "DisableAutoInput", disableAutoInput, comment);
        comment = "If TRUE, Machines will no longer have Auto-Output functionality. Not recommended, but knock yourself out.";
        disableAutoOutput = ThermalExpansion.CONFIG.get(category, "DisableAutoOutput", disableAutoOutput, comment);
        comment = "If TRUE, Machines will have much smaller internal energy (RF) storage. Processing speed will no longer scale with internal energy.";
        smallStorage = ThermalExpansion.CONFIG.get(category, "SmallStorage", smallStorage, comment);
        byte[] customAugments = new byte[]{0, 1, 2, 3, 4};
        int[] customPowerScale = new int[]{100, 150, 250, 400, 600};
        int[] customEnergyScale = new int[]{100, 105, 110, 115, 120};
        category = "Machine.AugmentSlots";
        comment = "Adjust the number of augments that Machines have at any given Level.\nProgression will be checked for validity - upgrading a block cannot result in fewer slots.";
        ThermalExpansion.CONFIG.getCategory(category).setComment(comment);
        boolean validScaling = true;
        for (i = 0; i <= 4; ++i) {
            customAugments[i] = (byte)ThermalExpansion.CONFIG.getConfiguration().getInt("Level" + i, category, (int)customAugments[i], 0, 9, "Augment Slots for Level " + i + " Machines.");
        }
        for (i = 1; i < customAugments.length; ++i) {
            if (customAugments[i] >= customAugments[i - 1]) continue;
            validScaling = false;
        }
        if (customAugmentScaling) {
            if (!validScaling) {
                ThermalExpansion.LOG.error(category + " settings are invalid. They will not be used.");
            } else {
                System.arraycopy(customAugments, 0, NUM_AUGMENTS, 0, NUM_AUGMENTS.length);
            }
        }
        category = "Machine.CustomPowerScaling";
        comment = "ADVANCED FEATURE - ONLY EDIT IF YOU KNOW WHAT YOU ARE DOING.\nValues are expressed as a percentage of Base Power; Base Scale Factor is 100 percent.\nValues will be checked for validity and rounded down to the nearest 10.";
        ThermalExpansion.CONFIG.getCategory(category).setComment(comment);
        validScaling = true;
        for (i = 1; i <= 4; ++i) {
            customPowerScale[i] = ThermalExpansion.CONFIG.getConfiguration().getInt("Level" + i, category, customPowerScale[i], 100, 100 * ((i + 1) * (i + 1)), "Scale Factor for Level " + i + " Machines.");
        }
        for (i = 1; i < customPowerScale.length; ++i) {
            int n = i;
            customPowerScale[n] = customPowerScale[n] / 10;
            int n2 = i;
            customPowerScale[n2] = customPowerScale[n2] * 10;
            if (customPowerScale[i] >= customPowerScale[i - 1]) continue;
            validScaling = false;
        }
        if (customPowerScaling) {
            if (!validScaling) {
                ThermalExpansion.LOG.error(category + " settings are invalid. They will not be used.");
            } else {
                System.arraycopy(customPowerScale, 0, POWER_SCALING, 0, POWER_SCALING.length);
            }
        }
        category = "Machine.CustomEnergyScaling";
        comment = "ADVANCED FEATURE - ONLY EDIT IF YOU KNOW WHAT YOU ARE DOING.\nValues are expressed as a percentage of Base Energy; Base Scale Factor is 100 percent.\nValues will be checked for validity and rounded down to the nearest 5.";
        ThermalExpansion.CONFIG.getCategory(category).setComment(comment);
        validScaling = true;
        for (i = 1; i <= 4; ++i) {
            customEnergyScale[i] = ThermalExpansion.CONFIG.getConfiguration().getInt("Level" + i, category, customEnergyScale[i], 100, 100 * ((i + 1) * (i + 1)), "Scale Factor for Level " + i + " Machines.");
        }
        for (i = 1; i < customEnergyScale.length; ++i) {
            int n = i;
            customEnergyScale[n] = customEnergyScale[n] / 20;
            int n3 = i;
            customEnergyScale[n3] = customEnergyScale[n3] * 20;
            if (customEnergyScale[i] >= customEnergyScale[i - 1]) continue;
            validScaling = false;
        }
        if (customEnergyScaling) {
            if (!validScaling) {
                ThermalExpansion.LOG.error(category + " settings are invalid. They will not be used.");
            } else {
                System.arraycopy(customEnergyScale, 0, ENERGY_SCALING, 0, ENERGY_SCALING.length);
            }
        }
    }

    public TileMachineBase() {
        this.sideConfig = SIDE_CONFIGS[this.getType()];
        this.slotConfig = SLOT_CONFIGS[this.getType()];
        this.energyConfig = ENERGY_CONFIGS[this.getType()].copy();
        this.energyStorage = new EnergyStorage(this.energyConfig.maxEnergy, this.energyConfig.maxPower * 4);
        Arrays.fill(this.augments, ItemStack.field_190927_a);
        this.setDefaultSides();
        this.enableAutoOutput = true;
    }

    protected Object getMod() {
        return ThermalExpansion.instance;
    }

    protected String getModVersion() {
        return "5.5.6";
    }

    protected String getTileName() {
        return "tile.thermalexpansion.machine." + BlockMachine.Type.values()[this.getType()].func_176610_l() + ".name";
    }

    protected int getLevelAutoInput() {
        return TEProps.levelAutoInput;
    }

    protected int getLevelAutoOutput() {
        return TEProps.levelAutoOutput;
    }

    protected int getLevelRSControl() {
        return TEProps.levelRedstoneControl;
    }

    public int getLightValue() {
        return this.isActive ? LIGHT_VALUES[this.getType()] : 0;
    }

    public boolean enableSecurity() {
        return enableSecurity;
    }

    public boolean canUpgrade(ItemStack upgrade) {
        if (!AugmentHelper.isUpgradeItem((ItemStack)upgrade) || !enableUpgrades) {
            return false;
        }
        IUpgradeItem.UpgradeType uType = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeType(upgrade);
        byte uLevel = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeLevel(upgrade);
        switch (uType) {
            case INCREMENTAL: {
                if (uLevel != this.level + 1) break;
                return !BlockMachine.enableClassicRecipes;
            }
            case FULL: {
                if (uLevel <= this.level) break;
                return !BlockMachine.enableClassicRecipes;
            }
            case CREATIVE: {
                return !this.isCreative && enableCreative;
            }
        }
        return false;
    }

    public boolean smallStorage() {
        return smallStorage;
    }

    protected boolean setLevel(int level) {
        if (super.setLevel(level)) {
            this.energyConfig.setDefaultParams(this.getBasePower(this.level), smallStorage);
            this.energyStorage.setCapacity(this.energyConfig.maxEnergy).setMaxTransfer(this.energyConfig.maxPower * 4);
            return true;
        }
        return false;
    }

    protected int getNumAugmentSlots(int level) {
        return NUM_AUGMENTS[MathHelper.clamp((int)level, (int)0, (int)4)];
    }

    protected void setLevelFlags() {
        super.setLevelFlags();
        if (disableAutoInput) {
            this.hasAutoInput = false;
        }
        if (disableAutoOutput) {
            this.hasAutoOutput = false;
        }
    }

    public void func_73660_a() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTick();
            if (this.canFinish()) {
                this.processFinish();
                this.transferOutput();
                this.transferInput();
                this.energyStorage.modifyEnergyStored(-this.processRem);
                if (!this.redstoneControlOrDisable() || !this.canStart()) {
                    this.processOff();
                } else {
                    this.processStart();
                }
            } else if (this.energyStorage.getEnergyStored() <= 0) {
                this.processOff();
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferOutput();
                this.transferInput();
            }
            if (this.timeCheckEighth() && this.canStart()) {
                this.processStart();
                this.processTick();
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
        this.chargeEnergy();
    }

    protected int getBasePower(int level) {
        return TileMachineBase.ENERGY_CONFIGS[this.getType()].maxPower * POWER_SCALING[MathHelper.clamp((int)level, (int)0, (int)4)] / 100;
    }

    protected int getBaseEnergy(int level) {
        return ENERGY_SCALING[MathHelper.clamp((int)level, (int)0, (int)4)] / 100;
    }

    protected int calcEnergy() {
        if (this.energyStorage.getEnergyStored() >= this.energyConfig.maxPowerLevel) {
            return this.energyConfig.maxPower;
        }
        if (this.energyStorage.getEnergyStored() < this.energyConfig.minPowerLevel) {
            return Math.min(this.energyConfig.minPower, this.energyStorage.getEnergyStored());
        }
        return this.energyStorage.getEnergyStored() / this.energyConfig.energyRamp;
    }

    protected int getMaxInputSlot() {
        return 0;
    }

    protected boolean canStart() {
        return false;
    }

    protected boolean canFinish() {
        return this.processRem <= 0 && this.hasValidInput();
    }

    protected boolean hasValidInput() {
        return true;
    }

    protected void clearRecipe() {
    }

    protected void getRecipe() {
    }

    protected void processStart() {
    }

    protected void processFinish() {
    }

    protected void processOff() {
        this.processRem = 0;
        this.isActive = false;
        this.wasActive = true;
        this.clearRecipe();
        if (this.field_145850_b != null) {
            this.tracker.markTime(this.field_145850_b);
        }
    }

    protected int processTick() {
        if (this.processRem <= 0) {
            return 0;
        }
        int energy = this.calcEnergy();
        this.energyStorage.modifyEnergyStored(-energy);
        this.processRem -= energy;
        return energy;
    }

    protected void transferInput() {
    }

    protected void transferOutput() {
    }

    protected void updateIfChanged(boolean curActive) {
        if (curActive != this.isActive && !this.wasActive) {
            if (LIGHT_VALUES[this.getType()] != 0) {
                this.updateLighting();
            }
            this.sendTilePacket(Side.CLIENT);
        } else if (this.wasActive && this.tracker.hasDelayPassed(this.field_145850_b, CoreProps.tileUpdateDelay)) {
            this.wasActive = false;
            if (LIGHT_VALUES[this.getType()] != 0) {
                this.updateLighting();
            }
            this.sendTilePacket(Side.CLIENT);
        }
    }

    public int getScaledProgress(int scale) {
        if (!this.isActive || this.processMax <= 0 || this.processRem <= 0) {
            return 0;
        }
        return scale * (this.processMax - this.processRem) / this.processMax;
    }

    public int getScaledSpeed(int scale) {
        if (!this.isActive) {
            return 0;
        }
        double power = this.energyStorage.getEnergyStored() / this.energyConfig.energyRamp;
        power = MathHelper.clip((double)power, (double)this.energyConfig.minPower, (double)this.energyConfig.maxPower);
        return MathHelper.round((double)((double)scale * power / (double)this.energyConfig.maxPower));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processMax = nbt.func_74762_e("ProcMax");
        this.processRem = nbt.func_74762_e("ProcRem");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("ProcMax", this.processMax);
        nbt.func_74768_a("ProcRem", this.processRem);
        return nbt;
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addInt(this.processMax);
        payload.addInt(this.processRem);
        return payload;
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.processMax = payload.getInt();
        this.processRem = payload.getInt();
    }

    protected void preAugmentInstall() {
        this.energyConfig.setDefaultParams(this.getBasePower(this.level), smallStorage);
        this.energyMod = 100;
        this.secondaryChance = 100;
        this.reuseChance = 0;
        this.hasModeAugment = false;
        this.augmentSecondaryNull = false;
    }

    protected void postAugmentInstall() {
        this.energyStorage.setCapacity(this.energyConfig.maxEnergy).setMaxTransfer(this.energyConfig.maxPower * 4);
        this.energyMod *= this.getBaseEnergy(this.level);
        this.secondaryChance = MathHelper.clamp((int)this.secondaryChance, (int)5, (int)100);
        this.reuseChance = MathHelper.clamp((int)this.reuseChance, (int)0, (int)95);
    }

    protected boolean isValidAugment(IAugmentItem.AugmentType type, String id) {
        if (type == IAugmentItem.AugmentType.CREATIVE && !this.isCreative) {
            return false;
        }
        if (type == IAugmentItem.AugmentType.MODE && this.hasModeAugment) {
            return false;
        }
        if (this.augmentSecondaryNull && "machineSecondaryNull".equals(id)) {
            return false;
        }
        return VALID_AUGMENTS_BASE.contains(id) || VALID_AUGMENTS[this.getType()].contains(id) || super.isValidAugment(type, id);
    }

    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if ("machinePower".equals(id)) {
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + this.getBasePower(this.level), smallStorage);
            this.energyMod += 10;
            return true;
        }
        if ("machineSecondary".equals(id)) {
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + this.getBasePower(this.level), smallStorage);
            this.secondaryChance -= 15;
            this.energyMod += 10;
            return true;
        }
        if (!this.augmentSecondaryNull && "machineSecondaryNull".equals(id)) {
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + this.getBasePower(this.level), smallStorage);
            this.augmentSecondaryNull = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public int updateAccelerable() {
        return this.processTick();
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = super.func_70298_a(slot, amount);
        if (ServerHelper.isServerWorld((World)this.field_145850_b) && slot <= this.getMaxInputSlot() && this.isActive && (this.inventory[slot].func_190926_b() || !this.hasValidInput())) {
            this.processOff();
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (ServerHelper.isServerWorld((World)this.field_145850_b) && slot <= this.getMaxInputSlot() && this.isActive && !this.inventory[slot].func_190926_b() && (stack.func_190926_b() || !stack.func_77969_a(this.inventory[slot]) || !this.hasValidInput())) {
            this.processOff();
        }
        super.func_70299_a(slot, stack);
    }

    public void func_70296_d() {
        if (this.isActive && !this.hasValidInput()) {
            this.processOff();
        }
        super.func_70296_d();
    }

    public int getInfoEnergyPerTick() {
        if (!this.isActive) {
            return 0;
        }
        return this.calcEnergy();
    }

    public int getInfoMaxEnergyPerTick() {
        return this.energyConfig.maxPower;
    }

    public boolean setFacing(int side, boolean alternate) {
        if (side < 2 || side > 5) {
            return false;
        }
        this.sideCache[side] = 0;
        this.facing = (byte)side;
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public int getNumPasses() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.MACHINE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.MACHINE_TOP;
            }
            return side != this.facing ? TETextures.MACHINE_SIDE : (this.isActive ? TETextures.MACHINE_ACTIVE[this.getType()] : TETextures.MACHINE_FACE[this.getType()]);
        }
        if (side < 6) {
            return TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]];
        }
        return TETextures.MACHINE_SIDE;
    }

    public boolean hasFluidUnderlay() {
        return false;
    }

    public FluidStack getRenderFluid() {
        return null;
    }

    public int getColorMask(BlockRenderLayer layer, EnumFacing side) {
        return -1;
    }

    static {
        VALID_AUGMENTS_BASE.add("machinePower");
    }
}

