/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.light;

import cofh.api.tileentity.ITileInfo;
import cofh.core.block.TileNameable;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class TileLightBase
extends TileNameable
implements ITileInfo {
    public byte mode;
    public int powerLevel;
    public boolean isPowered;
    int lightValue;
    public int color = -1;
    int renderColor = -1431655681;

    public static void config() {
    }

    protected Object getMod() {
        return ThermalExpansion.instance;
    }

    protected String getModVersion() {
        return "5.5.6";
    }

    protected String getTileName() {
        return "tile.thermalexpansion.light.name";
    }

    public int getLightValue() {
        return this.getInternalLight();
    }

    public int getInternalLight() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return this.lightValue;
        }
        switch (this.mode) {
            case 0: {
                return this.isPowered ? 15 : 0;
            }
            case 1: {
                return this.isPowered ? 0 : 15;
            }
            case 2: {
                return this.powerLevel;
            }
            case 3: {
                return 15 - this.powerLevel;
            }
            case 5: {
                return 15;
            }
        }
        return 0;
    }

    public void blockPlaced() {
        this.onNeighborBlockChange();
        this.sendTilePacket(Side.CLIENT);
    }

    public void onNeighborBlockChange() {
        boolean wasPowered = this.isPowered;
        int curLevel = this.powerLevel;
        this.powerLevel = this.field_145850_b.func_175687_A(this.field_174879_c);
        boolean bl = this.isPowered = this.powerLevel > 0;
        if (wasPowered != this.isPowered || curLevel != this.powerLevel) {
            this.updateLighting();
            this.sendTilePacket(Side.CLIENT);
        }
    }

    public boolean resetColor() {
        this.color = -1;
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public boolean setColor(int color) {
        if (color == this.color) {
            return false;
        }
        this.color = color;
        this.markChunkDirty();
        this.setRenderColor();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public boolean setRenderColor() {
        int internalColor = this.color == -1 ? -1 : this.color;
        int colorMod = 10 + this.getInternalLight() / 3;
        int red = (internalColor >> 16 & 0xFF) * colorMod / 15;
        int green = (internalColor >> 8 & 0xFF) * colorMod / 15;
        int blue = (internalColor & 0xFF) * colorMod / 15;
        this.renderColor = (red << 24) + (green << 16) + (blue << 8) + 255;
        return true;
    }

    public PacketBase getModePacket() {
        PacketBase payload = super.getModePacket();
        this.resetColor();
        return payload;
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
        this.resetColor();
    }

    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addInt(this.color);
        payload.addByte(this.mode);
        payload.addByte(this.getInternalLight());
        return payload;
    }

    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.color = payload.getInt();
        this.mode = payload.getByte();
        this.lightValue = payload.getByte();
        this.setRenderColor();
        this.updateLighting();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mode = nbt.func_74771_c("Mode");
        this.color = nbt.func_74762_e("Color");
        NBTTagCompound rsTag = nbt.func_74775_l("RS");
        this.isPowered = rsTag.func_74767_n("Power");
        this.powerLevel = rsTag.func_74771_c("Level");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Mode", this.mode);
        nbt.func_74768_a("Color", this.color);
        NBTTagCompound rsTag = new NBTTagCompound();
        rsTag.func_74757_a("Power", this.isPowered);
        rsTag.func_74774_a("Level", (byte)this.powerLevel);
        nbt.func_74782_a("RS", (NBTBase)rsTag);
        return nbt;
    }

    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        this.mode = tag.func_74771_c("Mode");
        this.setColor(tag.func_74762_e("Color"));
        this.updateLighting();
        return true;
    }

    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        tag.func_74774_a("Mode", this.mode);
        tag.func_74768_a("Color", this.color);
        return true;
    }

    public void getTileInfo(List<ITextComponent> info, EnumFacing side, EntityPlayer player, boolean debug) {
    }
}

