/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.java.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UnmodifiableConcatCollection<E>
implements Collection<E>,
Serializable {
    private static final long serialVersionUID = 1820017752578914078L;
    final Collection<Collection<? extends E>> cs;

    public UnmodifiableConcatCollection(Collection<Collection<? extends E>> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.cs = c;
    }

    @Override
    public int size() {
        return this.cs.stream().mapToInt(Collection::size).sum();
    }

    @Override
    public boolean isEmpty() {
        return this.cs.stream().allMatch(Collection::isEmpty);
    }

    @Override
    public boolean contains(Object o) {
        return this.cs.stream().anyMatch(c -> c.contains(o));
    }

    @Override
    public Object[] toArray() {
        return this.cs.stream().flatMap(Collection::stream).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.cs.stream().flatMap(Collection::stream).collect(Collectors.toList()).toArray(a);
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> f) {
        return this.cs.stream().flatMap(Collection::stream).toArray(f);
    }

    public String toString() {
        return this.cs.toString();
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<Collection<? extends E>> itrGlob = this.cs.iterator();
        return new Iterator<E>(){
            private Iterator<? extends E> i;
            {
                this.i = ((Collection)itrGlob.next()).iterator();
            }

            private Iterator<? extends E> getIterator() {
                if (!this.i.hasNext() && itrGlob.hasNext()) {
                    this.i = ((Collection)itrGlob.next()).iterator();
                }
                return this.i;
            }

            @Override
            public boolean hasNext() {
                return this.getIterator().hasNext();
            }

            @Override
            public E next() {
                return this.getIterator().next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                this.i.forEachRemaining(action);
                itrGlob.forEachRemaining(c -> c.iterator().forEachRemaining(action));
            }
        };
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.cs.stream().flatMap(Collection::stream).collect(Collectors.toSet()).containsAll(coll);
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.cs.stream().flatMap(Collection::stream).forEach(action);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<E> spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<E> stream() {
        return this.cs.stream().flatMap(Collection::stream);
    }

    @Override
    public Stream<E> parallelStream() {
        return this.cs.parallelStream().flatMap(Collection::parallelStream);
    }
}

