/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FieldUtil {
    public static void writeFieldsToNBT(Object obj, NBTTagCompound to, boolean privates) {
        try {
            Field[] fs;
            Class<?> c = obj.getClass();
            for (Field f : fs = c.getDeclaredFields()) {
                int mod;
                if (!f.isAccessible() && !privates || Modifier.isStatic(mod = f.getModifiers()) || Modifier.isFinal(mod)) continue;
                f.setAccessible(true);
                Object oj = f.get(obj);
                Class<?> o = oj.getClass();
                if (Boolean.TYPE.isAssignableFrom(o)) {
                    to.func_74757_a(f.getName(), ((Boolean)oj).booleanValue());
                    continue;
                }
                if (Byte.TYPE.isAssignableFrom(o)) {
                    to.func_74774_a(f.getName(), ((Byte)oj).byteValue());
                    continue;
                }
                if (byte[].class.isAssignableFrom(o)) {
                    to.func_74773_a(f.getName(), (byte[])oj);
                    continue;
                }
                if (Double.TYPE.isAssignableFrom(o)) {
                    to.func_74780_a(f.getName(), ((Double)oj).doubleValue());
                    continue;
                }
                if (Float.TYPE.isAssignableFrom(o)) {
                    to.func_74776_a(f.getName(), ((Float)oj).floatValue());
                    continue;
                }
                if (int[].class.isAssignableFrom(o)) {
                    to.func_74783_a(f.getName(), (int[])oj);
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(o)) {
                    to.func_74768_a(f.getName(), ((Integer)oj).intValue());
                    continue;
                }
                if (Long.TYPE.isAssignableFrom(o)) {
                    to.func_74772_a(f.getName(), ((Long)oj).longValue());
                    continue;
                }
                if (Short.TYPE.isAssignableFrom(o)) {
                    to.func_74777_a(f.getName(), ((Short)oj).shortValue());
                    continue;
                }
                if (String.class.isAssignableFrom(o)) {
                    to.func_74778_a(f.getName(), (String)oj);
                    continue;
                }
                if (NBTBase.class.isAssignableFrom(o)) {
                    to.func_74782_a(f.getName(), (NBTBase)oj);
                    continue;
                }
                if (!UUID.class.isAssignableFrom(o)) continue;
                to.func_186854_a(f.getName(), (UUID)oj);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void readFieldsFromNBT(Object to, NBTTagCompound from) {
        try {
            Field[] fs;
            Class<?> c = to.getClass();
            for (Field f : fs = c.getFields()) {
                f.setAccessible(true);
                int mod = f.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                Class<?> o = f.getType();
                if (Boolean.TYPE.isAssignableFrom(o)) {
                    f.setBoolean(to, from.func_74767_n(f.getName()));
                    continue;
                }
                if (Byte.TYPE.isAssignableFrom(o)) {
                    f.setByte(to, from.func_74771_c(f.getName()));
                    continue;
                }
                if (byte[].class.isAssignableFrom(o)) {
                    f.set(to, from.func_74770_j(f.getName()));
                    continue;
                }
                if (Double.TYPE.isAssignableFrom(o)) {
                    f.setDouble(to, from.func_74769_h(f.getName()));
                    continue;
                }
                if (Float.TYPE.isAssignableFrom(o)) {
                    f.setFloat(to, from.func_74760_g(f.getName()));
                    continue;
                }
                if (int[].class.isAssignableFrom(o)) {
                    f.set(to, from.func_74759_k(f.getName()));
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(o)) {
                    f.setInt(to, from.func_74762_e(f.getName()));
                    continue;
                }
                if (Long.TYPE.isAssignableFrom(o)) {
                    f.setLong(to, from.func_74763_f(f.getName()));
                    continue;
                }
                if (Short.TYPE.isAssignableFrom(o)) {
                    f.setShort(to, from.func_74765_d(f.getName()));
                    continue;
                }
                if (String.class.isAssignableFrom(o)) {
                    f.set(to, from.func_74779_i(f.getName()));
                    continue;
                }
                if (NBTBase.class.isAssignableFrom(o)) {
                    f.set(to, from.func_74781_a(f.getName()));
                    continue;
                }
                if (!UUID.class.isAssignableFrom(o)) continue;
                f.set(to, from.func_186857_a(f.getName()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

